(function($) {
    'use strict';

    // Clean up dashboard header on load - remove any injected elements
    $(document).ready(function() {
        // Remove all admin notices inside safetypress-wrap
        $('.safetypress-wrap .notice, .safetypress-wrap .updated, .safetypress-wrap .error, .safetypress-wrap .is-dismissible').remove();
        
        // Remove any unexpected elements in dashboard header
        $('.sp-dashboard-header').children().each(function() {
            var $el = $(this);
            if (!$el.hasClass('sp-header-brand') && !$el.hasClass('sp-header-actions')) {
                $el.remove();
            }
        });
        
        // Remove any unexpected elements in header brand
        $('.sp-header-brand').children().each(function() {
            var $el = $(this);
            if (!$el.hasClass('sp-logo-box') && !$el.hasClass('sp-header-title')) {
                $el.remove();
            }
        });
        
        // Remove any unexpected elements in header title
        $('.sp-header-title').children().each(function() {
            var $el = $(this);
            if (!$el.is('h1') && !$el.hasClass('sp-header-subtitle')) {
                $el.remove();
            }
        });
    });

    $('#safetypress-block-ip-form').on('submit', function(e) {
        e.preventDefault();
        var ip = $('#block-ip').val();
        if (!ip) { alert('Bitte IP eingeben.'); return; }
        $.post(safetypress.ajax_url, {
            action: 'safetypress_block_ip',
            nonce: safetypress.nonce,
            ip: ip,
            reason: $('#block-reason').val(),
            permanent: $('#block-permanent').is(':checked') ? 'true' : 'false'
        }, function(r) { r.success ? location.reload() : alert(r.data.message); });
    });

    $('.safetypress-unblock-ip').on('click', function() {
        if (!confirm('IP entsperren?')) return;
        $.post(safetypress.ajax_url, {
            action: 'safetypress_unblock_ip',
            nonce: safetypress.nonce,
            ip: $(this).data('ip')
        }, function(r) { r.success ? location.reload() : alert(r.data.message); });
    });

    function runScan(type) {
        $('#safetypress-scan-progress').show();
        $('#safetypress-quick-scan, #safetypress-deep-scan').prop('disabled', true);
        $.post(safetypress.ajax_url, {
            action: 'safetypress_run_scan',
            nonce: safetypress.nonce,
            scan_type: type
        }, function(r) {
            $('#safetypress-scan-progress').hide();
            $('#safetypress-quick-scan, #safetypress-deep-scan').prop('disabled', false);
            r.success ? location.reload() : alert(r.data.message || 'Fehler');
        }).fail(function() {
            $('#safetypress-scan-progress').hide();
            $('#safetypress-quick-scan, #safetypress-deep-scan').prop('disabled', false);
            alert('Fehler');
        });
    }

    $('#safetypress-quick-scan').on('click', function() { runScan('quick'); });
    $('#safetypress-deep-scan').on('click', function() { if (!$(this).hasClass('disabled')) runScan('deep'); });

    $('#safetypress-activate-license-form').on('submit', function(e) {
        e.preventDefault();
        var key = $('#safetypress-license-key').val();
        if (!key) { $('#safetypress-license-message').html('<p class="error">Bitte Schlüssel eingeben.</p>'); return; }
        $.post(safetypress.ajax_url, {
            action: 'safetypress_activate_license',
            nonce: safetypress.nonce,
            license_key: key
        }, function(r) {
            if (r.success) {
                $('#safetypress-license-message').html('<p class="success">' + r.data.message + '</p>');
                setTimeout(function() { location.reload(); }, 1500);
            } else {
                $('#safetypress-license-message').html('<p class="error">' + r.data.message + '</p>');
            }
        });
    });

    $('#safetypress-deactivate-license').on('click', function() {
        if (!confirm('Lizenz deaktivieren?')) return;
        $.post(safetypress.ajax_url, {
            action: 'safetypress_deactivate_license',
            nonce: safetypress.nonce
        }, function(r) { r.success ? location.reload() : alert(r.data.message); });
    });

})(jQuery);
