<?php
if (!defined('ABSPATH')) exit;

$is_pro = function_exists('safetypress') && safetypress()->is_pro();

// Geplante Scans Status
$schedule = get_option('safetypress_scheduled_scan', 'disabled');
$last_scan = get_option('safetypress_last_scheduled_scan', []);
$next_daily = wp_next_scheduled('safetypress_daily_scan');
$next_weekly = wp_next_scheduled('safetypress_weekly_scan');
$next_scan = $next_daily ?: $next_weekly;

// Login-URL Status
$custom_login = get_option('safetypress_custom_login_url', '');
$login_enabled = get_option('safetypress_enable_custom_login', 0);
$login_redirect = get_option('safetypress_login_redirect_url', '');
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-header">
        <div class="sp-header-left">
            <div class="sp-logo">⚙️</div>
            <div class="sp-header-text">
                <h1>Einstellungen</h1>
                <p>Allgemeine Konfiguration</p>
            </div>
        </div>
    </div>

    <!-- Navigation -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <form method="post" action="options.php" id="safetypress-settings-form">
        <?php settings_fields('safetypress_general'); ?>
        
        <div class="sp-grid">
            
            <!-- Left Column -->
            <div class="sp-col-6">
                
                <!-- Sicherheitsmodule -->
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon blue">🛡️</span>
                            Sicherheitsmodule
                        </h3>
                    </div>
                    
                    <div class="sp-module-list">
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-info">
                                    <h4>Web Application Firewall</h4>
                                    <p>SQL-Injection, XSS & mehr blockieren</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_enable_firewall" value="0">
                                <input type="checkbox" name="safetypress_enable_firewall" value="1" <?php checked(get_option('safetypress_enable_firewall', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-info">
                                    <h4>Login-Schutz</h4>
                                    <p>Brute-Force-Angriffe verhindern</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_enable_login_protection" value="0">
                                <input type="checkbox" name="safetypress_enable_login_protection" value="1" <?php checked(get_option('safetypress_enable_login_protection', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-info">
                                    <h4>WordPress Hardening</h4>
                                    <p>Security Headers & Härtung</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_enable_hardening" value="0">
                                <input type="checkbox" name="safetypress_enable_hardening" value="1" <?php checked(get_option('safetypress_enable_hardening', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-info">
                                    <h4>Activity Log</h4>
                                    <p>Sicherheitsereignisse protokollieren</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_enable_activity_log" value="0">
                                <input type="checkbox" name="safetypress_enable_activity_log" value="1" <?php checked(get_option('safetypress_enable_activity_log', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-info">
                                    <h4>Zwei-Faktor-Authentifizierung</h4>
                                    <p>TOTP-basierte 2FA <?php if (!$is_pro): ?><span class="sp-badge-pro">PRO</span><?php endif; ?></p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_enable_2fa" value="0">
                                <input type="checkbox" name="safetypress_enable_2fa" value="1" <?php checked(get_option('safetypress_enable_2fa', 0)); ?> <?php echo !$is_pro ? 'disabled' : ''; ?>>
                                <span class="sp-toggle-track" <?php echo !$is_pro ? 'style="opacity: 0.5;"' : ''; ?>></span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Geplante Scans -->
                <div class="sp-card" style="margin-top: 24px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon green">🔄</span>
                            Geplante Scans
                            <?php if (!$is_pro): ?><span class="sp-badge-pro">PRO</span><?php endif; ?>
                        </h3>
                    </div>
                    
                    <?php if ($is_pro): ?>
                    <div class="sp-form-group">
                        <label class="sp-form-label">Scan-Intervall</label>
                        <select name="safetypress_scheduled_scan" class="sp-form-select">
                            <option value="disabled" <?php selected($schedule, 'disabled'); ?>>Deaktiviert</option>
                            <option value="daily" <?php selected($schedule, 'daily'); ?>>Täglich</option>
                            <option value="weekly" <?php selected($schedule, 'weekly'); ?>>Wöchentlich (Montag)</option>
                        </select>
                    </div>
                    
                    <div class="sp-form-group" style="margin-top: 12px;">
                        <label class="sp-form-label">Scan-Uhrzeit</label>
                        <input type="time" name="safetypress_scheduled_scan_time" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_scheduled_scan_time', '03:00')); ?>" style="max-width: 120px;">
                        <p class="sp-form-hint">Wann soll der automatische Scan laufen?</p>
                    </div>
                    
                    <div class="sp-module-item" style="margin-top: 16px;">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Ergebnisse per E-Mail</h4>
                                <p>Scan-Report nach Abschluss senden</p>
                            </div>
                        </div>
                        <label class="sp-toggle">
                            <input type="hidden" name="safetypress_scheduled_scan_email" value="0">
                            <input type="checkbox" name="safetypress_scheduled_scan_email" value="1" <?php checked(get_option('safetypress_scheduled_scan_email', 1)); ?>>
                            <span class="sp-toggle-track"></span>
                        </label>
                    </div>
                    
                    <?php if ($schedule !== 'disabled'): ?>
                        <div class="sp-info-box" style="margin-top: 16px;">
                            <div class="sp-info-row">
                                <span class="sp-info-label">Nächster Scan:</span>
                                <span class="sp-info-value"><?php echo $next_scan ? date_i18n('d.m.Y H:i', $next_scan) : '–'; ?></span>
                            </div>
                            <?php if (!empty($last_scan['time'])): ?>
                            <div class="sp-info-row">
                                <span class="sp-info-label">Letzter Scan:</span>
                                <span class="sp-info-value"><?php echo esc_html($last_scan['time']); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php else: ?>
                    <!-- Nicht-Pro: Deaktiviert anzeigen -->
                    <div class="sp-form-group" style="opacity: 0.6;">
                        <label class="sp-form-label">Scan-Intervall</label>
                        <select class="sp-form-select" disabled>
                            <option>Deaktiviert</option>
                            <option>Täglich</option>
                            <option>Wöchentlich</option>
                        </select>
                        <p class="sp-form-hint">Upgrade auf Pro für automatische Scans</p>
                    </div>
                    
                    <div class="sp-form-group" style="margin-top: 12px; opacity: 0.6;">
                        <label class="sp-form-label">Scan-Uhrzeit</label>
                        <input type="time" class="sp-form-input" value="03:00" style="max-width: 120px;" disabled>
                    </div>
                    
                    <div class="sp-module-item" style="margin-top: 16px; opacity: 0.6;">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Ergebnisse per E-Mail</h4>
                                <p>Scan-Report nach Abschluss senden</p>
                            </div>
                        </div>
                        <label class="sp-toggle">
                            <span class="sp-toggle-track" style="opacity: 0.5;"></span>
                        </label>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if (class_exists('WooCommerce')): ?>
                <div class="sp-card" style="margin-top: 24px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon orange">🛒</span>
                            WooCommerce
                        </h3>
                    </div>
                    
                    <div class="sp-module-list">
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-info">
                                    <h4>Betrugsschutz</h4>
                                    <p>Verdächtige Bestellungen erkennen</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_enable_woo_protection" value="0">
                                <input type="checkbox" name="safetypress_enable_woo_protection" value="1" <?php checked(get_option('safetypress_enable_woo_protection', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                    </div>
                    
                    <div class="sp-form-group" style="margin-top: 16px;">
                        <label class="sp-form-label">Fraud-Score Schwellenwert</label>
                        <input type="number" name="safetypress_fraud_score_threshold" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_fraud_score_threshold', 70)); ?>" min="1" max="100" style="max-width: 120px;">
                        <p class="sp-form-hint">Bestellungen über diesem Wert werden zurückgehalten</p>
                    </div>
                </div>
                <?php endif; ?>
                
            </div>
            
            <!-- Right Column -->
            <div class="sp-col-6">
                
                <!-- E-Mail-Benachrichtigungen -->
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon purple">📧</span>
                            E-Mail-Benachrichtigungen
                        </h3>
                    </div>
                    
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Benachrichtigungen aktivieren</h4>
                                <p>E-Mails bei Sicherheitsvorfällen</p>
                            </div>
                        </div>
                        <label class="sp-toggle">
                            <input type="hidden" name="safetypress_email_notifications" value="0">
                            <input type="checkbox" name="safetypress_email_notifications" value="1" <?php checked(get_option('safetypress_email_notifications', 1)); ?>>
                            <span class="sp-toggle-track"></span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group" style="margin-top: 16px;">
                        <label class="sp-form-label">E-Mail-Adresse</label>
                        <input type="email" name="safetypress_notification_email" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_notification_email', get_option('admin_email'))); ?>">
                        <p class="sp-form-hint">Mehrere Adressen mit Komma trennen</p>
                    </div>
                    
                    <div class="sp-notification-types" style="margin-top: 20px; padding: 16px; background: var(--sp-surface); border-radius: 8px;">
                        <h4 style="margin: 0 0 12px; font-size: 14px; color: var(--sp-text);">Sie werden benachrichtigt bei:</h4>
                        <ul style="margin: 0; padding: 0; list-style: none; font-size: 13px; color: var(--sp-text-muted);">
                            <li style="padding: 4px 0;">✅ Brute-Force Angriffen</li>
                            <li style="padding: 4px 0;">✅ Malware-Funden</li>
                            <li style="padding: 4px 0;">✅ Neuen Admin-Logins (unbekannte IP)</li>
                            <li style="padding: 4px 0;">✅ Lizenzablauf</li>
                            <li style="padding: 4px 0;">✅ Geplante Scan-Ergebnisse</li>
                        </ul>
                    </div>
                    
                    <button type="button" id="sp-send-test-email" class="sp-btn sp-btn-secondary" style="margin-top: 16px;">
                        📤 Test-E-Mail senden
                    </button>
                    <span id="sp-test-email-result" style="margin-left: 12px;"></span>
                </div>
                
                <!-- Login-URL anpassen -->
                <div class="sp-card" style="margin-top: 24px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon cyan">🔐</span>
                            Login-URL anpassen
                            <?php if (!$is_pro): ?><span class="sp-badge-pro">PRO</span><?php endif; ?>
                        </h3>
                    </div>
                    
                    <?php if ($is_pro): ?>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Benutzerdefinierte Login-URL</h4>
                                <p>Versteckt /wp-login.php</p>
                            </div>
                        </div>
                        <label class="sp-toggle">
                            <input type="hidden" name="safetypress_enable_custom_login" value="0">
                            <input type="checkbox" name="safetypress_enable_custom_login" value="1" <?php checked($login_enabled); ?>>
                            <span class="sp-toggle-track"></span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group" style="margin-top: 16px;">
                        <label class="sp-form-label">Login-Pfad</label>
                        <div class="sp-input-group">
                            <span class="sp-input-prefix"><?php echo esc_html(home_url('/')); ?></span>
                            <input type="text" name="safetypress_custom_login_url" class="sp-form-input" value="<?php echo esc_attr($custom_login); ?>" placeholder="mein-login" pattern="[a-z0-9-]+" minlength="4">
                        </div>
                        <p class="sp-form-hint">Kleinbuchstaben, Zahlen, Bindestriche. Min. 4 Zeichen.</p>
                    </div>
                    
                    <div class="sp-form-group" style="margin-top: 16px;">
                        <label class="sp-form-label">Weiterleitung bei Blockierung</label>
                        <input type="url" name="safetypress_login_redirect_url" class="sp-form-input" value="<?php echo esc_attr($login_redirect); ?>" placeholder="<?php echo esc_attr(home_url('/')); ?>">
                        <p class="sp-form-hint">Wohin sollen Besucher weitergeleitet werden, die /wp-admin oder /wp-login.php direkt aufrufen? Leer lassen fuer 404-Fehler.</p>
                    </div>
                    
                    <?php if ($login_enabled && !empty($custom_login)): ?>
                        <div class="sp-alert sp-alert-success" style="margin-top: 16px;">
                            <strong>✅ Aktiv!</strong> Ihre Login-URL:<br>
                            <code><?php echo esc_html(home_url($custom_login)); ?></code>
                        </div>
                    <?php endif; ?>
                    
                    <?php else: ?>
                    <!-- Nicht-Pro: Zeige Vorschau aber deaktiviert -->
                    <div class="sp-module-item" style="opacity: 0.6;">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Benutzerdefinierte Login-URL</h4>
                                <p>Versteckt /wp-login.php</p>
                            </div>
                        </div>
                        <label class="sp-toggle">
                            <span class="sp-toggle-track" style="opacity: 0.5;"></span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group" style="margin-top: 16px; opacity: 0.6;">
                        <label class="sp-form-label">Login-Pfad</label>
                        <div class="sp-input-group">
                            <span class="sp-input-prefix"><?php echo esc_html(home_url('/')); ?></span>
                            <input type="text" class="sp-form-input" value="" placeholder="mein-login" disabled>
                        </div>
                    </div>
                    
                    <div class="sp-alert sp-alert-info" style="margin-top: 16px;">
                        🔒 Upgrade auf Pro um die Login-URL zu ändern.
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- Activity Log -->
                <div class="sp-card" style="margin-top: 24px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon">📋</span>
                            Activity Log
                        </h3>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Log-Aufbewahrung (Tage)</label>
                        <input type="number" name="safetypress_log_retention_days" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_log_retention_days', 30)); ?>" min="1" max="365" style="max-width: 120px;">
                        <p class="sp-form-hint">Ältere Einträge werden automatisch gelöscht</p>
                    </div>
                </div>
                
                <div style="margin-top: 24px;">
                    <button type="submit" class="sp-btn sp-btn-primary sp-btn-lg">
                        💾 Einstellungen speichern
                    </button>
                </div>
                
            </div>
        </div>
    </form>
</div>

<style>
.sp-badge-pro { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #fff; font-size: 10px; padding: 2px 6px; border-radius: 4px; margin-left: 8px; font-weight: 600; }
.sp-form-select { width: 100%; padding: 10px 12px; border: 1px solid var(--sp-border); border-radius: 8px; background: var(--sp-surface); color: var(--sp-text); font-size: 14px; }
.sp-form-hint { color: var(--sp-text-muted); font-size: 12px; margin-top: 6px; }
.sp-info-box { background: var(--sp-surface); border-radius: 8px; padding: 12px; }
.sp-info-row { display: flex; justify-content: space-between; padding: 6px 0; font-size: 13px; }
.sp-info-label { color: var(--sp-text-muted); }
.sp-info-value { color: var(--sp-text); font-weight: 500; }
.sp-input-group { display: flex; align-items: stretch; }
.sp-input-prefix { display: flex; align-items: center; background: #1e293b; border: 1px solid #334155; border-right: none; padding: 14px 16px; border-radius: 12px 0 0 12px; color: #94a3b8; font-size: 13px; white-space: nowrap; }
.sp-input-group .sp-form-input { border-radius: 0 12px 12px 0 !important; flex: 1; background: #0f172a !important; border: 1px solid #334155 !important; color: #f1f5f9 !important; padding: 14px 16px !important; }
.sp-alert { padding: 12px 16px; border-radius: 8px; font-size: 13px; }
.sp-alert-success { background: rgba(34, 197, 94, 0.15); border: 1px solid rgba(34, 197, 94, 0.3); color: #22c55e; }
.sp-alert-info { background: rgba(59, 130, 246, 0.15); border: 1px solid rgba(59, 130, 246, 0.3); color: #60a5fa; }
.sp-alert code { background: rgba(0,0,0,0.2); padding: 4px 8px; border-radius: 4px; display: inline-block; margin-top: 8px; }
.sp-btn-secondary { background: var(--sp-surface); color: var(--sp-text); border: 1px solid var(--sp-border); }
.sp-btn-secondary:hover { background: var(--sp-border); }
.sp-btn-lg { padding: 14px 28px; font-size: 15px; }
</style>

<script>
jQuery(document).ready(function($) {
    $('#sp-send-test-email').on('click', function() {
        var $btn = $(this), $result = $('#sp-test-email-result');
        $btn.prop('disabled', true).text('Sende...');
        $result.text('');
        $.post(safetypress.ajax_url, {
            action: 'safetypress_send_test_email',
            nonce: safetypress.nonce
        }, function(response) {
            $result.html(response.success ? '<span style="color:#22c55e;">✅ Gesendet!</span>' : '<span style="color:#ef4444;">❌ Fehler</span>');
            $btn.prop('disabled', false).text('📤 Test-E-Mail senden');
        });
    });
});
</script>
