<?php
if (!defined('ABSPATH')) exit;
$last = get_transient('safetypress_last_scan');
$is_pro = function_exists('safetypress') && safetypress()->is_pro();
$stats = isset($last['stats']) ? $last['stats'] : null;
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-header">
        <div class="sp-header-left">
            <div class="sp-logo">🔍</div>
            <div class="sp-header-text">
                <h1>Security Scanner</h1>
                <p>Malware-Erkennung & Datei-Analyse</p>
            </div>
        </div>
    </div>

    <!-- Navigation -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <div class="sp-grid">
        
        <!-- Scan Actions -->
        <div class="sp-col-4">
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon green">🚀</span>
                        Scan starten
                    </h3>
                </div>
                
                <div style="margin-bottom: 16px;">
                    <button id="safetypress-quick-scan" class="sp-btn sp-btn-primary" style="width: 100%; margin-bottom: 12px;">
                        ⚡ Quick-Scan
                    </button>
                    <p style="color: var(--sp-text-muted); font-size: 0.8rem; margin: 0;">
                        Prüft Core-Dateien, Uploads & Berechtigungen
                    </p>
                </div>
                
                <div style="margin-bottom: 16px;">
                    <button id="safetypress-deep-scan" class="sp-btn <?php echo $is_pro ? 'sp-btn-secondary' : ''; ?>" style="width: 100%; margin-bottom: 12px; <?php echo !$is_pro ? 'opacity: 0.5; cursor: not-allowed; background: var(--sp-bg-hover); color: var(--sp-text-muted); border: 1px solid var(--sp-border);' : ''; ?>" <?php echo !$is_pro ? 'disabled' : ''; ?>>
                        🔬 Deep-Scan
                        <?php if (!$is_pro): ?><span class="sp-module-badge pro" style="margin-left: 8px;">PRO</span><?php endif; ?>
                    </button>
                    <p style="color: var(--sp-text-muted); font-size: 0.8rem; margin: 0;">
                        Malware-Signaturen, Backdoors & verdächtiger Code
                    </p>
                </div>
                
                <div id="safetypress-scan-progress" style="display: none;">
                    <div class="sp-alert sp-alert-info">
                        <span class="sp-alert-icon">⏳</span>
                        <div class="sp-alert-content">
                            <h4>Scan läuft...</h4>
                            <p>Bitte warten Sie, während die Dateien analysiert werden.</p>
                        </div>
                    </div>
                    <div class="sp-progress">
                        <div class="sp-progress-bar" style="width: 0%; animation: scanProgress 10s linear forwards;"></div>
                    </div>
                </div>
            </div>

            <!-- Last Scan Info -->
            <?php if ($last && $stats): ?>
            <div class="sp-card" style="margin-top: 24px;">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon blue">📊</span>
                        Scan-Statistik
                    </h3>
                </div>
                <div class="sp-module-list">
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Zeitpunkt</h4>
                                <p><?php echo esc_html($last['scan_time']); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Scan-Typ</h4>
                                <p><?php echo $last['scan_type'] === 'deep' ? 'Deep-Scan' : 'Quick-Scan'; ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Dateien gescannt</h4>
                            </div>
                        </div>
                        <span style="font-size: 1.1rem; font-weight: 600; color: var(--sp-accent);">
                            <?php echo number_format($stats['files_scanned'] ?? 0); ?>
                        </span>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Verzeichnisse</h4>
                            </div>
                        </div>
                        <span style="font-size: 1.1rem; font-weight: 600; color: var(--sp-text);">
                            <?php echo number_format($stats['directories_scanned'] ?? 0); ?>
                        </span>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Prüfungen</h4>
                            </div>
                        </div>
                        <span style="font-size: 1.1rem; font-weight: 600; color: var(--sp-text);">
                            <?php echo number_format($stats['checks_performed'] ?? 0); ?>
                        </span>
                    </div>
                    <?php if (isset($stats['duration'])): ?>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Dauer</h4>
                            </div>
                        </div>
                        <span style="font-size: 1.1rem; font-weight: 600; color: var(--sp-text);">
                            <?php echo esc_html($stats['duration']); ?>s
                        </span>
                    </div>
                    <?php endif; ?>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Probleme gefunden</h4>
                            </div>
                        </div>
                        <span style="font-size: 1.25rem; font-weight: 700; color: <?php echo count($last['issues']) > 0 ? 'var(--sp-red)' : 'var(--sp-accent)'; ?>;">
                            <?php echo count($last['issues']); ?>
                        </span>
                    </div>
                </div>
            </div>
            <?php elseif ($last): ?>
            <div class="sp-card" style="margin-top: 24px;">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon blue">📊</span>
                        Letzter Scan
                    </h3>
                </div>
                <div class="sp-module-list">
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Zeitpunkt</h4>
                                <p><?php echo esc_html($last['scan_time']); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-info">
                                <h4>Probleme gefunden</h4>
                            </div>
                        </div>
                        <span style="font-size: 1.25rem; font-weight: 700; color: <?php echo count($last['issues']) > 0 ? 'var(--sp-red)' : 'var(--sp-accent)'; ?>;">
                            <?php echo count($last['issues']); ?>
                        </span>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Scan Results -->
        <div class="sp-col-8">
            
            <!-- Scan Details (was wurde gescannt) -->
            <?php if ($last && $stats && !empty($stats['scan_details'])): ?>
            <div class="sp-card" style="margin-bottom: 24px;">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon cyan">✓</span>
                        Was wurde gescannt
                    </h3>
                </div>
                
                <div class="sp-scan-details-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 16px;">
                    <?php foreach ($stats['scan_details'] as $detail): ?>
                    <div class="sp-scan-area" style="background: var(--sp-bg-dark); border-radius: 8px; padding: 16px;">
                        <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 12px;">
                            <span style="font-size: 1.25rem;"><?php echo esc_html($detail['icon']); ?></span>
                            <h4 style="margin: 0; font-size: 0.95rem; font-weight: 600;"><?php echo esc_html($detail['area']); ?></h4>
                        </div>
                        <div class="sp-scan-items" style="display: flex; flex-direction: column; gap: 8px;">
                            <?php foreach ($detail['items'] as $item): 
                                $status_color = 'var(--sp-accent)';
                                $status_icon = '✓';
                                if ($item['status'] === 'warning') {
                                    $status_color = 'var(--sp-orange)';
                                    $status_icon = '⚠';
                                } elseif ($item['status'] === 'critical') {
                                    $status_color = 'var(--sp-red)';
                                    $status_icon = '✗';
                                } elseif ($item['status'] === 'info') {
                                    $status_color = 'var(--sp-blue)';
                                    $status_icon = 'ℹ';
                                } elseif ($item['status'] === 'checked') {
                                    $status_color = 'var(--sp-text-muted)';
                                    $status_icon = '•';
                                }
                            ?>
                            <div style="display: flex; align-items: flex-start; gap: 8px; font-size: 0.85rem;">
                                <span style="color: <?php echo $status_color; ?>; flex-shrink: 0;"><?php echo $status_icon; ?></span>
                                <div>
                                    <span style="color: var(--sp-text);"><?php echo esc_html($item['name']); ?></span>
                                    <?php if (!empty($item['detail'])): ?>
                                    <span style="color: var(--sp-text-muted); display: block; font-size: 0.8rem;"><?php echo esc_html($item['detail']); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                
                <?php if (!empty($stats['scanned_areas'])): ?>
                <div style="margin-top: 16px; padding-top: 16px; border-top: 1px solid var(--sp-border);">
                    <p style="color: var(--sp-text-muted); font-size: 0.85rem; margin: 0;">
                        <strong>Geprüfte Bereiche:</strong> <?php echo esc_html(implode(' • ', $stats['scanned_areas'])); ?>
                    </p>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <!-- Issues / Ergebnisse -->
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon purple">📋</span>
                        Gefundene Probleme
                    </h3>
                </div>
                
                <?php if (!$last): ?>
                    <div class="sp-empty">
                        <div class="sp-empty-icon">🔍</div>
                        <p class="sp-empty-text">Noch kein Scan durchgeführt.<br>Starten Sie einen Quick-Scan, um Ihre Website zu überprüfen.</p>
                    </div>
                <?php elseif (empty($last['issues'])): ?>
                    <div class="sp-alert sp-alert-success">
                        <span class="sp-alert-icon">✅</span>
                        <div class="sp-alert-content">
                            <h4>Alles in Ordnung!</h4>
                            <p>Keine Sicherheitsprobleme gefunden. Ihre Website ist sauber.</p>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="sp-alert sp-alert-warning" style="margin-bottom: 24px;">
                        <span class="sp-alert-icon">⚠️</span>
                        <div class="sp-alert-content">
                            <h4><?php echo count($last['issues']); ?> Problem(e) gefunden</h4>
                            <p>Bitte überprüfen Sie die folgenden Einträge.</p>
                        </div>
                    </div>
                    
                    <div class="sp-table-wrap">
                        <table class="sp-table">
                            <thead>
                                <tr>
                                    <th style="width: 100px;">Typ</th>
                                    <th style="width: 200px;">Datei</th>
                                    <th>Beschreibung</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($last['issues'] as $issue): 
                                    $badge_class = $issue['type'] === 'critical' ? 'critical' : ($issue['type'] === 'warning' ? 'warning' : 'info');
                                ?>
                                    <tr>
                                        <td>
                                            <span class="sp-table-badge <?php echo $badge_class; ?>">
                                                <?php echo esc_html(ucfirst($issue['type'])); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <code style="background: var(--sp-bg-dark); padding: 4px 8px; border-radius: 4px; font-size: 0.8rem; word-break: break-all;">
                                                <?php echo esc_html($issue['file']); ?>
                                            </code>
                                        </td>
                                        <td>
                                            <div><?php echo esc_html($issue['message']); ?></div>
                                            <?php if (!empty($issue['recommendation'])): ?>
                                            <div style="color: var(--sp-text-muted); font-size: 0.85rem; margin-top: 4px;">
                                                💡 <?php echo esc_html($issue['recommendation']); ?>
                                            </div>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    </div>

</div>

<style>
@keyframes scanProgress {
    0% { width: 0%; }
    100% { width: 100%; }
}
</style>
