<?php
if (!defined('ABSPATH')) exit;

// Current page ermitteln
$current_page = isset($_GET['page']) ? sanitize_text_field($_GET['page']) : 'safetypress';

// Blocked IPs für Badge
$blocked_count = 0;
if (function_exists('safetypress') && safetypress()->firewall) {
    $blocked = safetypress()->firewall->get_blocked_ips();
    $blocked_count = is_array($blocked) ? count($blocked) : 0;
}

// Last Scan Issues für Badge
$scan_issues = 0;
$last_scan = get_transient('safetypress_last_scan');
if ($last_scan && isset($last_scan['issues'])) {
    $scan_issues = count($last_scan['issues']);
}

// Integrity Issues für Badge
$integrity_issues = 0;
$integrity_check = get_option('safetypress_last_integrity_check', []);
if (!empty($integrity_check['modified_files'])) {
    $integrity_issues = count($integrity_check['modified_files']);
}

$nav_items = array(
    array(
        'page' => 'safetypress',
        'icon' => '📊',
        'label' => 'Dashboard',
        'badge' => 0,
    ),
    array(
        'page' => 'safetypress-firewall',
        'icon' => '🛡️',
        'label' => 'Firewall',
        'badge' => $blocked_count,
    ),
    array(
        'page' => 'safetypress-login',
        'icon' => '🔐',
        'label' => 'Login-Schutz',
        'badge' => 0,
    ),
    array(
        'page' => 'safetypress-hardening',
        'icon' => '🔒',
        'label' => 'Hardening',
        'badge' => 0,
    ),
    array(
        'page' => 'safetypress-scanner',
        'icon' => '🔍',
        'label' => 'Scanner',
        'badge' => $scan_issues,
    ),
    array(
        'page' => 'safetypress-integrity',
        'icon' => '✅',
        'label' => 'Integrität',
        'badge' => $integrity_issues,
    ),
    array(
        'page' => 'safetypress-logs',
        'icon' => '📋',
        'label' => 'Activity Log',
        'badge' => 0,
    ),
    array(
        'page' => 'safetypress-settings',
        'icon' => '⚙️',
        'label' => 'Einstellungen',
        'badge' => 0,
    ),
    array(
        'page' => 'safetypress-license',
        'icon' => '🔑',
        'label' => 'Lizenz',
        'badge' => 0,
    ),
);
?>

<nav class="sp-dashboard-nav">
    <?php foreach ($nav_items as $item): 
        $is_active = ($current_page === $item['page']);
    ?>
    <a href="<?php echo admin_url('admin.php?page=' . $item['page']); ?>" 
       class="sp-nav-item <?php echo $is_active ? 'active' : ''; ?>">
        <span class="sp-nav-icon"><?php echo $item['icon']; ?></span>
        <span><?php echo esc_html($item['label']); ?></span>
        <?php if ($item['badge'] > 0): ?>
            <span class="sp-nav-badge"><?php echo $item['badge']; ?></span>
        <?php endif; ?>
    </a>
    <?php endforeach; ?>
</nav>
