<?php
if (!defined('ABSPATH')) exit;
$logs = safetypress()->logger ? safetypress()->logger->get_logs(array('limit' => 100)) : array();
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-header">
        <div class="sp-header-left">
            <div class="sp-logo">📋</div>
            <div class="sp-header-text">
                <h1>Activity Log</h1>
                <p>Sicherheitsereignisse & Aktivitäten</p>
            </div>
        </div>
        <div class="sp-header-right">
            <a href="<?php echo wp_nonce_url(admin_url('admin-ajax.php?action=safetypress_export_logs'), 'safetypress_admin', 'nonce'); ?>" class="sp-btn sp-btn-secondary">
                📥 Als CSV exportieren
            </a>
        </div>
    </div>

    <!-- Navigation -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <div class="sp-grid">
        <div class="sp-col-12">
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon purple">📊</span>
                        Letzte <?php echo count($logs); ?> Einträge
                    </h3>
                </div>
                
                <?php if (empty($logs)): ?>
                    <div class="sp-empty">
                        <div class="sp-empty-icon">📭</div>
                        <p class="sp-empty-text">Noch keine Log-Einträge vorhanden.</p>
                    </div>
                <?php else: ?>
                    <div class="sp-table-wrap">
                        <table class="sp-table">
                            <thead>
                                <tr>
                                    <th>Datum</th>
                                    <th>Event</th>
                                    <th>Nachricht</th>
                                    <th>IP-Adresse</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($logs as $log): 
                                    $badge_class = 'info';
                                    if (strpos($log->event_type, 'block') !== false || strpos($log->event_type, 'fail') !== false) {
                                        $badge_class = 'critical';
                                    } elseif (strpos($log->event_type, 'warning') !== false) {
                                        $badge_class = 'warning';
                                    } elseif (strpos($log->event_type, 'success') !== false) {
                                        $badge_class = 'success';
                                    }
                                ?>
                                    <tr>
                                        <td style="white-space: nowrap; color: var(--sp-text-secondary);">
                                            <?php echo esc_html(date('d.m.Y H:i', strtotime($log->created_at))); ?>
                                        </td>
                                        <td>
                                            <span class="sp-table-badge <?php echo $badge_class; ?>">
                                                <?php echo esc_html($log->event_type); ?>
                                            </span>
                                        </td>
                                        <td><?php echo esc_html($log->event_message); ?></td>
                                        <td>
                                            <code style="background: var(--sp-bg-dark); padding: 4px 8px; border-radius: 4px; font-size: 0.8rem;">
                                                <?php echo esc_html($log->ip_address); ?>
                                            </code>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

</div>
