<?php
if (!defined('ABSPATH')) exit;
$stats = safetypress()->login_protection ? safetypress()->login_protection->get_statistics() : array(
    'total_attempts' => 0, 'failed_attempts' => 0, 'successful_logins' => 0, 'unique_ips' => 0
);
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-header">
        <div class="sp-header-left">
            <div class="sp-logo">🔐</div>
            <div class="sp-header-text">
                <h1>Login-Schutz</h1>
                <p>Brute-Force-Prevention & Login-Sicherheit</p>
            </div>
        </div>
        <div class="sp-header-right">
            <span class="sp-badge <?php echo get_option('safetypress_enable_login_protection', 1) ? 'sp-badge-pro' : 'sp-badge-free'; ?>">
                <?php echo get_option('safetypress_enable_login_protection', 1) ? '✓ Aktiv' : 'Inaktiv'; ?>
            </span>
        </div>
    </div>

    <!-- Navigation -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <!-- Stats -->
    <div class="sp-stats-row" style="grid-template-columns: repeat(4, 1fr); margin-bottom: 32px;">
        <div class="sp-stat-card">
            <div class="sp-stat-icon" style="background: linear-gradient(135deg, #3b82f6, #60a5fa);">📊</div>
            <div class="sp-stat-value"><?php echo number_format(intval($stats['total_attempts'])); ?></div>
            <div class="sp-stat-label">Versuche gesamt</div>
        </div>
        <div class="sp-stat-card">
            <div class="sp-stat-icon" style="background: linear-gradient(135deg, #ef4444, #f87171);">❌</div>
            <div class="sp-stat-value"><?php echo number_format(intval($stats['failed_attempts'])); ?></div>
            <div class="sp-stat-label">Fehlgeschlagen</div>
        </div>
        <div class="sp-stat-card">
            <div class="sp-stat-icon" style="background: linear-gradient(135deg, #22c55e, #4ade80);">✓</div>
            <div class="sp-stat-value"><?php echo number_format(intval($stats['successful_logins'])); ?></div>
            <div class="sp-stat-label">Erfolgreich</div>
        </div>
        <div class="sp-stat-card">
            <div class="sp-stat-icon" style="background: linear-gradient(135deg, #f97316, #fb923c);">🌐</div>
            <div class="sp-stat-value"><?php echo number_format(intval($stats['unique_ips'])); ?></div>
            <div class="sp-stat-label">Eindeutige IPs</div>
        </div>
    </div>

    <div class="sp-grid">
        
        <!-- Settings -->
        <div class="sp-col-6">
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon blue">⚙️</span>
                        Einstellungen
                    </h3>
                </div>
                
                <form method="post" action="options.php">
                    <?php settings_fields('safetypress_login'); ?>
                    
                    <div class="sp-module-list" style="margin-bottom: 24px;">
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-info">
                                    <h4>Login-Schutz aktivieren</h4>
                                    <p>Brute-Force-Angriffe verhindern</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_enable_login_protection" value="0">
                                <input type="checkbox" name="safetypress_enable_login_protection" value="1" <?php checked(get_option('safetypress_enable_login_protection', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Maximale Login-Versuche</label>
                        <input type="number" name="safetypress_max_login_attempts" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_max_login_attempts', 5)); ?>" min="1" max="20" style="max-width: 120px;">
                        <p style="color: var(--sp-text-muted); font-size: 0.85rem; margin-top: 8px;">Nach dieser Anzahl wird die IP gesperrt</p>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Sperrdauer (Minuten)</label>
                        <input type="number" name="safetypress_lockout_duration" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_lockout_duration', 30)); ?>" min="1" max="1440" style="max-width: 120px;">
                        <p style="color: var(--sp-text-muted); font-size: 0.85rem; margin-top: 8px;">Wie lange eine IP gesperrt bleibt</p>
                    </div>
                    
                    <button type="submit" class="sp-btn sp-btn-primary">
                        💾 Speichern
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Info -->
        <div class="sp-col-6">
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon green">ℹ️</span>
                        So funktioniert's
                    </h3>
                </div>
                
                <div class="sp-module-list">
                    <div class="sp-module-item" style="border: none;">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #3b82f6, #60a5fa);">1</div>
                            <div class="sp-module-info">
                                <h4>Versuche zählen</h4>
                                <p>Jeder fehlgeschlagene Login-Versuch wird pro IP gezählt</p>
                            </div>
                        </div>
                    </div>
                    <div class="sp-module-item" style="border: none;">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #f97316, #fb923c);">2</div>
                            <div class="sp-module-info">
                                <h4>Limit erreicht</h4>
                                <p>Nach X Versuchen wird die IP automatisch gesperrt</p>
                            </div>
                        </div>
                    </div>
                    <div class="sp-module-item" style="border: none;">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #ef4444, #f87171);">3</div>
                            <div class="sp-module-info">
                                <h4>Sperre aktiv</h4>
                                <p>Gesperrte IPs können sich nicht einloggen</p>
                            </div>
                        </div>
                    </div>
                    <div class="sp-module-item" style="border: none;">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #22c55e, #4ade80);">4</div>
                            <div class="sp-module-info">
                                <h4>Automatische Entsperrung</h4>
                                <p>Nach Ablauf der Sperrdauer ist die IP wieder frei</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>
