<?php
if (!defined('ABSPATH')) exit;
$is_pro = function_exists('safetypress') && safetypress()->is_pro();
$info = safetypress()->license ? safetypress()->license->get_license_info() : array('is_valid' => false);

// Success-Nachricht nach Aktivierung
$show_success = isset($_GET['activated']) && $_GET['activated'] === '1';
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-header">
        <div class="sp-header-left">
            <div class="sp-logo">🔑</div>
            <div class="sp-header-text">
                <h1>Lizenz</h1>
                <p>Pro-Features freischalten</p>
            </div>
        </div>
        <div class="sp-header-right">
            <?php if ($is_pro): ?>
                <span class="sp-badge sp-badge-pro">✓ Pro aktiv</span>
            <?php else: ?>
                <span class="sp-badge sp-badge-free">Free Version</span>
            <?php endif; ?>
        </div>
    </div>

    <!-- Navigation -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <?php if ($show_success): ?>
    <div class="sp-alert sp-alert-success" style="margin-bottom: 24px;">
        <span class="sp-alert-icon">🎉</span>
        <div class="sp-alert-content">
            <strong>Vielen Dank!</strong> Ihr SafetyPress Pro-Abonnement wurde erfolgreich aktiviert.
        </div>
    </div>
    <?php endif; ?>
    
    <?php if (!empty($info['warning'])): ?>
    <div class="sp-alert sp-alert-warning" style="margin-bottom: 24px;">
        <span class="sp-alert-icon">⚠️</span>
        <div class="sp-alert-content">
            <?php echo esc_html($info['warning']); ?>
        </div>
    </div>
    <?php endif; ?>

    <div class="sp-grid">
        
        <!-- License Status -->
        <div class="sp-col-6">
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon <?php echo $is_pro ? 'green' : 'orange'; ?>">
                            <?php echo $is_pro ? '✓' : '🔓'; ?>
                        </span>
                        Lizenzstatus
                    </h3>
                </div>
                
                <?php if ($is_pro): ?>
                    <!-- Active License -->
                    <div style="text-align: center; padding: 24px 0;">
                        <div style="width: 100px; height: 100px; margin: 0 auto 24px; background: linear-gradient(135deg, var(--sp-accent), var(--sp-blue)); border-radius: 24px; display: flex; align-items: center; justify-content: center; font-size: 3rem; box-shadow: 0 0 50px var(--sp-accent-glow);">
                            ✓
                        </div>
                        <h2 style="color: var(--sp-text); font-size: 1.75rem; margin: 0 0 8px 0;">Pro-Lizenz aktiv</h2>
                        <p style="color: var(--sp-accent); font-size: 1.1rem; margin: 0 0 24px 0;">
                            <?php 
                            if (!empty($info['is_appsumo']) && $info['is_appsumo']) {
                                echo 'AppSumo Tier ' . $info['tier'] . ' (Lifetime)';
                            } elseif (!empty($info['type']) && $info['type'] === 'developer') {
                                echo 'Developer License (Unlimited)';
                            } elseif (!empty($info['is_stripe']) && $info['is_stripe']) {
                                echo 'Pro Subscription';
                                if (!empty($info['expires'])) {
                                    echo ' • Nächste Zahlung: ' . date('d.m.Y', strtotime($info['expires']));
                                }
                            } else {
                                echo 'Pro License';
                            }
                            ?>
                        </p>
                        
                        <?php if (!empty($info['key'])): ?>
                        <div style="display: inline-block; padding: 16px 32px; background: var(--sp-bg-dark); border: 1px solid var(--sp-border); border-radius: var(--sp-radius-sm); font-family: 'Consolas', monospace; color: var(--sp-text-secondary); letter-spacing: 2px; margin-bottom: 24px;">
                            <?php echo esc_html($info['key']); ?>
                        </div>
                        <?php endif; ?>
                        
                        <div class="sp-module-list" style="margin-top: 24px;">
                            <div class="sp-module-item">
                                <div class="sp-module-left">
                                    <div class="sp-module-info">
                                        <h4>Aktiviert am</h4>
                                    </div>
                                </div>
                                <span style="color: var(--sp-text-secondary);"><?php echo esc_html(!empty($info['activated']) ? $info['activated'] : 'N/A'); ?></span>
                            </div>
                            <div class="sp-module-item">
                                <div class="sp-module-left">
                                    <div class="sp-module-info">
                                        <h4>Erlaubte Websites</h4>
                                    </div>
                                </div>
                                <span style="color: var(--sp-accent); font-weight: 600;">
                                    <?php echo (!empty($info['sites_allowed']) && $info['sites_allowed'] >= 999) ? 'Unbegrenzt' : ($info['sites_allowed'] ?? 1); ?>
                                </span>
                            </div>
                            <?php if (!empty($info['is_stripe']) && $info['is_stripe']): ?>
                            <div class="sp-module-item">
                                <div class="sp-module-left">
                                    <div class="sp-module-info">
                                        <h4>Abo-Status</h4>
                                    </div>
                                </div>
                                <span style="color: var(--sp-accent); font-weight: 600;">
                                    <?php 
                                    $status_labels = array(
                                        'active' => '✓ Aktiv',
                                        'trialing' => '🎁 Testphase',
                                        'past_due' => '⚠️ Überfällig',
                                        'canceled' => '✗ Gekündigt',
                                    );
                                    $stripe_status = !empty($info['stripe_status']) ? $info['stripe_status'] : '';
                                    echo isset($status_labels[$stripe_status]) ? $status_labels[$stripe_status] : $stripe_status;
                                    ?>
                                </span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Action Buttons für Pro-User -->
                        <div style="margin-top: 24px; display: flex; gap: 12px; justify-content: center; flex-wrap: wrap;">
                            <?php if (!empty($info['is_stripe']) && $info['is_stripe']): ?>
                                <button id="safetypress-open-portal" class="sp-btn sp-btn-secondary">
                                    ⚙️ Abo verwalten
                                </button>
                            <?php endif; ?>
                            <button id="safetypress-deactivate-license" class="sp-btn sp-btn-outline">
                                Lizenz deaktivieren
                            </button>
                        </div>
                    </div>
                <?php else: ?>
                    <!-- Purchase / Activate License -->
                    <div style="padding: 24px 0;">
                        <div style="text-align: center; margin-bottom: 32px;">
                            <div style="width: 80px; height: 80px; margin: 0 auto 20px; background: var(--sp-bg-hover); border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 2.5rem;">
                                🚀
                            </div>
                            <h3 style="color: var(--sp-text); margin: 0 0 8px 0;">Upgrade auf Pro</h3>
                            <p style="color: var(--sp-text-secondary); margin: 0;">Alle Premium-Features freischalten</p>
                        </div>
                        
                        <!-- Stripe Checkout Button -->
                        <div style="text-align: center; margin-bottom: 32px;">
                            <button id="safetypress-checkout-btn" class="sp-btn sp-btn-primary sp-btn-lg" style="width: 100%; max-width: 320px; padding: 18px 32px; font-size: 1.1rem;">
                                <span class="sp-btn-icon">💳</span>
                                Jetzt Pro kaufen
                            </button>
                            <p style="color: var(--sp-text-muted); font-size: 0.85rem; margin-top: 12px;">
                                Sicherer Checkout über Stripe • Jederzeit kündbar
                            </p>
                        </div>
                        
                        <div style="text-align: center; margin: 32px 0; position: relative;">
                            <span style="display: inline-block; padding: 0 16px; background: var(--sp-bg-card); position: relative; z-index: 1; color: var(--sp-text-muted);">oder</span>
                            <div style="border-bottom: 1px solid var(--sp-border); position: absolute; left: 0; right: 0; top: 50%;"></div>
                        </div>
                        
                        <!-- License Key Activation -->
                        <div style="padding-top: 16px;">
                            <p style="color: var(--sp-text-muted); font-size: 0.9rem; margin-bottom: 16px; text-align: center;">
                                Bereits einen Lizenzschlüssel oder AppSumo-Code?
                            </p>
                            <form id="safetypress-activate-license-form">
                                <div class="sp-form-group">
                                    <label class="sp-form-label">Lizenzschlüssel</label>
                                    <input type="text" id="safetypress-license-key" class="sp-form-input" placeholder="z.B. APPSUMO1-XXXXXXXX oder PRO-XXXX-XXXX">
                                </div>
                                <button type="submit" class="sp-btn sp-btn-secondary" style="width: 100%;">
                                    🔓 Lizenz aktivieren
                                </button>
                            </form>
                            <div id="safetypress-license-message" style="margin-top: 16px;"></div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Pro Features -->
        <div class="sp-col-6">
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon purple">⭐</span>
                        Pro-Features
                    </h3>
                </div>
                
                <div class="sp-module-list">
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #ef4444, #f87171);">🔬</div>
                            <div class="sp-module-info">
                                <h4>Deep Malware-Scanner</h4>
                                <p>Erkennt Backdoors, Shells & verdächtigen Code</p>
                            </div>
                        </div>
                        <span class="sp-module-badge <?php echo $is_pro ? 'active' : 'pro'; ?>"><?php echo $is_pro ? '✓' : 'PRO'; ?></span>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #3b82f6, #60a5fa);">📱</div>
                            <div class="sp-module-info">
                                <h4>Zwei-Faktor-Authentifizierung</h4>
                                <p>TOTP mit Google Authenticator & Co.</p>
                            </div>
                        </div>
                        <span class="sp-module-badge <?php echo $is_pro ? 'active' : 'pro'; ?>"><?php echo $is_pro ? '✓' : 'PRO'; ?></span>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #a855f7, #c084fc);">📄</div>
                            <div class="sp-module-info">
                                <h4>Datei-Integritätsprüfung</h4>
                                <p>Erkennt veränderte Core-Dateien</p>
                            </div>
                        </div>
                        <span class="sp-module-badge <?php echo $is_pro ? 'active' : 'pro'; ?>"><?php echo $is_pro ? '✓' : 'PRO'; ?></span>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #f97316, #fb923c);">🛒</div>
                            <div class="sp-module-info">
                                <h4>WooCommerce Betrugsschutz</h4>
                                <p>Fraud-Score für verdächtige Bestellungen</p>
                            </div>
                        </div>
                        <span class="sp-module-badge <?php echo $is_pro ? 'active' : 'pro'; ?>"><?php echo $is_pro ? '✓' : 'PRO'; ?></span>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #06b6d4, #22d3ee);">📅</div>
                            <div class="sp-module-info">
                                <h4>Geplante Scans</h4>
                                <p>Automatische tägliche/wöchentliche Scans</p>
                            </div>
                        </div>
                        <span class="sp-module-badge <?php echo $is_pro ? 'active' : 'pro'; ?>"><?php echo $is_pro ? '✓' : 'PRO'; ?></span>
                    </div>
                    <div class="sp-module-item">
                        <div class="sp-module-left">
                            <div class="sp-module-icon" style="background: linear-gradient(135deg, #22c55e, #4ade80);">💬</div>
                            <div class="sp-module-info">
                                <h4>Prioritäts-Support</h4>
                                <p>Schnelle Hilfe bei Fragen & Problemen</p>
                            </div>
                        </div>
                        <span class="sp-module-badge <?php echo $is_pro ? 'active' : 'pro'; ?>"><?php echo $is_pro ? '✓' : 'PRO'; ?></span>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>

<style>
#safetypress-license-message .success {
    padding: 16px;
    background: rgba(34, 197, 94, 0.1);
    border: 1px solid rgba(34, 197, 94, 0.3);
    border-radius: var(--sp-radius-sm);
    color: var(--sp-accent);
}
#safetypress-license-message .error {
    padding: 16px;
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.3);
    border-radius: var(--sp-radius-sm);
    color: var(--sp-red);
}
.sp-alert {
    display: flex;
    align-items: flex-start;
    gap: 16px;
    padding: 16px 20px;
    border-radius: var(--sp-radius);
    background: var(--sp-bg-card);
    border: 1px solid var(--sp-border);
}
.sp-alert-success {
    background: rgba(34, 197, 94, 0.1);
    border-color: rgba(34, 197, 94, 0.3);
}
.sp-alert-warning {
    background: rgba(245, 158, 11, 0.1);
    border-color: rgba(245, 158, 11, 0.3);
}
.sp-alert-icon {
    font-size: 1.5rem;
    line-height: 1;
}
.sp-alert-content {
    flex: 1;
    color: var(--sp-text);
}
.sp-btn-lg {
    font-size: 1.1rem !important;
}
.sp-btn-outline {
    background: transparent;
    border: 1px solid var(--sp-border);
    color: var(--sp-text-secondary);
}
.sp-btn-outline:hover {
    background: var(--sp-bg-hover);
    color: var(--sp-text);
}
.sp-btn-icon {
    margin-right: 8px;
}
#safetypress-checkout-btn:disabled {
    opacity: 0.7;
    cursor: wait;
}
</style>

<script>
(function($) {
    'use strict';
    
    // Stripe Checkout
    $('#safetypress-checkout-btn').on('click', function() {
        var $btn = $(this);
        var originalText = $btn.html();
        
        $btn.prop('disabled', true).html('<span class="sp-btn-icon">⏳</span> Wird geladen...');
        
        $.post(safetypress.ajax_url, {
            action: 'safetypress_create_checkout',
            nonce: safetypress.nonce
        }, function(response) {
            if (response.success && response.data.checkout_url) {
                // Redirect zu Stripe Checkout
                window.location.href = response.data.checkout_url;
            } else {
                alert(response.data.message || 'Ein Fehler ist aufgetreten.');
                $btn.prop('disabled', false).html(originalText);
            }
        }).fail(function() {
            alert('Verbindungsfehler. Bitte versuchen Sie es erneut.');
            $btn.prop('disabled', false).html(originalText);
        });
    });
    
    // Customer Portal öffnen
    $('#safetypress-open-portal').on('click', function() {
        var $btn = $(this);
        var originalText = $btn.html();
        
        $btn.prop('disabled', true).html('⏳ Wird geladen...');
        
        $.post(safetypress.ajax_url, {
            action: 'safetypress_get_portal_url',
            nonce: safetypress.nonce
        }, function(response) {
            if (response.success && response.data.portal_url) {
                window.location.href = response.data.portal_url;
            } else {
                alert(response.data.message || 'Kundenportal konnte nicht geöffnet werden.');
                $btn.prop('disabled', false).html(originalText);
            }
        }).fail(function() {
            alert('Verbindungsfehler.');
            $btn.prop('disabled', false).html(originalText);
        });
    });
    
})(jQuery);
</script>
