<?php
if (!defined('ABSPATH')) exit;

$is_pro = function_exists('safetypress') && safetypress()->is_pro();
$last_check = get_option('safetypress_last_integrity_check', []);
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-header">
        <div class="sp-header-left">
            <div class="sp-logo">🔍</div>
            <div class="sp-header-text">
                <h1>Datei-Integrität</h1>
                <p>WordPress Core-Dateien prüfen & reparieren</p>
            </div>
        </div>
        <div class="sp-header-right">
            <?php if ($is_pro): ?>
                <span class="sp-pro-badge">✓ Pro aktiv</span>
            <?php else: ?>
                <span class="sp-free-badge">Free</span>
            <?php endif; ?>
        </div>
    </div>

    <!-- Navigation -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <div class="sp-grid">
        
        <!-- Left Column: Check & Results -->
        <div class="sp-col-8">
            
            <!-- Prüfung starten -->
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon blue">✅</span>
                        Core-Integritätsprüfung
                    </h3>
                </div>
                
                <p style="color: var(--sp-text-muted); margin-bottom: 20px;">
                    Vergleicht Ihre WordPress Core-Dateien mit den Original-Checksums von WordPress.org. 
                    Modifizierte oder fehlende Dateien können auf eine Infektion hindeuten.
                </p>
                
                <div class="sp-integrity-actions">
                    <button type="button" id="sp-check-integrity" class="sp-btn sp-btn-primary" <?php echo !$is_pro ? 'disabled' : ''; ?>>
                        🔍 Integrität prüfen
                    </button>
                    
                    <?php if (!$is_pro): ?>
                        <span class="sp-pro-hint">Pro-Feature erforderlich</span>
                    <?php endif; ?>
                </div>
                
                <!-- Progress -->
                <div id="sp-integrity-progress" style="display: none; margin-top: 20px;">
                    <div class="sp-progress-bar">
                        <div class="sp-progress-fill"></div>
                    </div>
                    <p class="sp-progress-text">Prüfe WordPress Core-Dateien...</p>
                </div>
            </div>
            
            <!-- Ergebnisse -->
            <div class="sp-card" style="margin-top: 24px;" id="sp-integrity-results" <?php echo empty($last_check) ? 'style="display:none;"' : ''; ?>>
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon <?php echo ($last_check['status'] ?? '') === 'ok' ? 'green' : 'red'; ?>">
                            <?php echo ($last_check['status'] ?? '') === 'ok' ? '✅' : '⚠️'; ?>
                        </span>
                        Prüfungsergebnis
                    </h3>
                    <?php if (!empty($last_check['checked_at'])): ?>
                        <span class="sp-card-meta">Geprüft: <?php echo esc_html($last_check['checked_at']); ?></span>
                    <?php endif; ?>
                </div>
                
                <!-- Statistiken -->
                <div class="sp-integrity-stats">
                    <div class="sp-stat-item">
                        <div class="sp-stat-number"><?php echo count($last_check['modified_files'] ?? []); ?></div>
                        <div class="sp-stat-label">Modifiziert</div>
                    </div>
                    <div class="sp-stat-item">
                        <div class="sp-stat-number"><?php echo count($last_check['missing_files'] ?? []); ?></div>
                        <div class="sp-stat-label">Fehlend</div>
                    </div>
                    <div class="sp-stat-item">
                        <div class="sp-stat-number"><?php echo count($last_check['unknown_files'] ?? []); ?></div>
                        <div class="sp-stat-label">Unbekannt</div>
                    </div>
                    <div class="sp-stat-item">
                        <div class="sp-stat-number"><?php echo $last_check['total_files'] ?? 0; ?></div>
                        <div class="sp-stat-label">Geprüft</div>
                    </div>
                </div>
                
                <?php if (!empty($last_check['modified_files'])): ?>
                <!-- Modifizierte Dateien -->
                <div class="sp-file-section">
                    <h4 class="sp-section-title">
                        <span class="sp-section-icon red">🚨</span>
                        Modifizierte Dateien
                        <button type="button" id="sp-repair-all" class="sp-btn sp-btn-sm sp-btn-danger" style="margin-left: auto;">
                            🔧 Alle reparieren
                        </button>
                    </h4>
                    <div class="sp-file-list" id="sp-modified-files">
                        <?php foreach ($last_check['modified_files'] as $file): ?>
                        <div class="sp-file-item" data-file="<?php echo esc_attr($file['file']); ?>">
                            <div class="sp-file-info">
                                <code class="sp-file-path"><?php echo esc_html($file['file']); ?></code>
                                <span class="sp-file-meta">Geändert: <?php echo esc_html($file['modified'] ?? ''); ?></span>
                            </div>
                            <button type="button" class="sp-btn sp-btn-sm sp-repair-file">🔧 Reparieren</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($last_check['missing_files'])): ?>
                <!-- Fehlende Dateien -->
                <div class="sp-file-section">
                    <h4 class="sp-section-title">
                        <span class="sp-section-icon orange">📁</span>
                        Fehlende Dateien
                    </h4>
                    <div class="sp-file-list">
                        <?php foreach ($last_check['missing_files'] as $file): ?>
                        <div class="sp-file-item" data-file="<?php echo esc_attr($file['file']); ?>">
                            <div class="sp-file-info">
                                <code class="sp-file-path"><?php echo esc_html($file['file']); ?></code>
                            </div>
                            <button type="button" class="sp-btn sp-btn-sm sp-repair-file">🔧 Wiederherstellen</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($last_check['unknown_files'])): ?>
                <!-- Unbekannte Dateien -->
                <div class="sp-file-section">
                    <h4 class="sp-section-title">
                        <span class="sp-section-icon blue">❓</span>
                        Unbekannte Dateien
                    </h4>
                    <p class="sp-section-hint">Diese Dateien gehören nicht zum WordPress Core. Prüfen Sie, ob sie legitim sind.</p>
                    <div class="sp-file-list">
                        <?php foreach (array_slice($last_check['unknown_files'], 0, 20) as $file): ?>
                        <div class="sp-file-item">
                            <div class="sp-file-info">
                                <code class="sp-file-path"><?php echo esc_html($file['file']); ?></code>
                                <span class="sp-file-meta"><?php echo size_format($file['size'] ?? 0); ?></span>
                            </div>
                        </div>
                        <?php endforeach; ?>
                        <?php if (count($last_check['unknown_files']) > 20): ?>
                            <p class="sp-more-hint">... und <?php echo count($last_check['unknown_files']) - 20; ?> weitere</p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (($last_check['status'] ?? '') === 'ok'): ?>
                <div class="sp-success-box">
                    <div class="sp-success-icon">✅</div>
                    <div class="sp-success-text">
                        <strong>Alle Core-Dateien sind intakt!</strong>
                        <p>Keine modifizierten oder fehlenden Dateien gefunden.</p>
                    </div>
                </div>
                <?php endif; ?>
                
            </div>
            
        </div>
        
        <!-- Right Column: Info -->
        <div class="sp-col-4">
            
            <!-- Info-Box -->
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon">ℹ️</span>
                        Was ist das?
                    </h3>
                </div>
                <div class="sp-info-content">
                    <p>Die Integritätsprüfung vergleicht Ihre WordPress-Dateien mit den offiziellen Versionen von WordPress.org.</p>
                    
                    <h4>Geprüft werden:</h4>
                    <ul>
                        <li>wp-includes/ Dateien</li>
                        <li>wp-admin/ Dateien</li>
                        <li>Root-Dateien (wp-login.php, etc.)</li>
                    </ul>
                    
                    <h4>Nicht geprüft:</h4>
                    <ul>
                        <li>wp-content/ (Plugins, Themes)</li>
                        <li>wp-config.php</li>
                    </ul>
                </div>
            </div>
            
            <!-- Auto-Repair Info -->
            <div class="sp-card" style="margin-top: 24px;">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon green">🔧</span>
                        Auto-Repair
                    </h3>
                </div>
                <div class="sp-info-content">
                    <p>Die Auto-Repair Funktion:</p>
                    <ul>
                        <li>✅ Erstellt automatisch ein Backup</li>
                        <li>✅ Lädt Original von WordPress.org</li>
                        <li>✅ Ersetzt die modifizierte Datei</li>
                    </ul>
                    <p class="sp-warning-text">
                        ⚠️ Prüfen Sie vor dem Reparieren, ob die Änderungen gewollt waren (z.B. durch Plugins).
                    </p>
                </div>
            </div>
            
            <!-- WordPress Version -->
            <div class="sp-card" style="margin-top: 24px;">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon blue">📦</span>
                        WordPress Version
                    </h3>
                </div>
                <div class="sp-version-info">
                    <div class="sp-version-number"><?php global $wp_version; echo esc_html($wp_version); ?></div>
                    <p>Checksums werden für diese Version geprüft.</p>
                </div>
            </div>
            
        </div>
    </div>
</div>

<style>
.sp-integrity-actions { display: flex; align-items: center; gap: 16px; }
.sp-pro-hint { color: var(--sp-text-muted); font-size: 13px; }
.sp-progress-bar { height: 8px; background: var(--sp-surface); border-radius: 4px; overflow: hidden; }
.sp-progress-fill { height: 100%; width: 0; background: linear-gradient(90deg, #667eea, #764ba2); transition: width 0.3s; animation: progress-pulse 1.5s infinite; }
@keyframes progress-pulse { 0%, 100% { opacity: 1; } 50% { opacity: 0.7; } }
.sp-progress-text { color: var(--sp-text-muted); font-size: 13px; margin-top: 8px; }

.sp-integrity-stats { display: grid; grid-template-columns: repeat(4, 1fr); gap: 16px; margin-bottom: 24px; padding: 20px; background: var(--sp-surface); border-radius: 12px; }
.sp-stat-item { text-align: center; }
.sp-stat-number { font-size: 28px; font-weight: 700; color: var(--sp-text); }
.sp-stat-label { font-size: 12px; color: var(--sp-text-muted); margin-top: 4px; }

.sp-file-section { margin-top: 24px; }
.sp-section-title { display: flex; align-items: center; gap: 8px; margin-bottom: 12px; font-size: 15px; color: var(--sp-text); }
.sp-section-icon { font-size: 18px; }
.sp-section-icon.red { color: #ef4444; }
.sp-section-icon.orange { color: #f59e0b; }
.sp-section-icon.blue { color: #3b82f6; }
.sp-section-hint { color: var(--sp-text-muted); font-size: 13px; margin-bottom: 12px; }

.sp-file-list { background: var(--sp-surface); border-radius: 8px; overflow: hidden; }
.sp-file-item { display: flex; align-items: center; justify-content: space-between; padding: 12px 16px; border-bottom: 1px solid var(--sp-border); }
.sp-file-item:last-child { border-bottom: none; }
.sp-file-item.repaired { background: rgba(34, 197, 94, 0.1); }
.sp-file-path { font-size: 13px; color: var(--sp-text); background: rgba(0,0,0,0.2); padding: 4px 8px; border-radius: 4px; }
.sp-file-meta { font-size: 11px; color: var(--sp-text-muted); margin-left: 12px; }
.sp-more-hint { text-align: center; padding: 12px; color: var(--sp-text-muted); font-size: 13px; }

.sp-btn-sm { padding: 6px 12px; font-size: 12px; }
.sp-btn-danger { background: #ef4444; color: #fff; }
.sp-btn-danger:hover { background: #dc2626; }

.sp-success-box { display: flex; align-items: center; gap: 16px; padding: 20px; background: rgba(34, 197, 94, 0.1); border: 1px solid rgba(34, 197, 94, 0.3); border-radius: 12px; margin-top: 24px; }
.sp-success-icon { font-size: 48px; }
.sp-success-text strong { color: #22c55e; font-size: 16px; }
.sp-success-text p { color: var(--sp-text-muted); margin: 4px 0 0; }

.sp-info-content { color: var(--sp-text-muted); font-size: 13px; line-height: 1.6; }
.sp-info-content h4 { color: var(--sp-text); font-size: 13px; margin: 16px 0 8px; }
.sp-info-content ul { margin: 0; padding-left: 20px; }
.sp-info-content li { padding: 4px 0; }
.sp-warning-text { color: #f59e0b; margin-top: 12px; padding: 12px; background: rgba(245, 158, 11, 0.1); border-radius: 8px; }

.sp-version-info { text-align: center; padding: 20px; }
.sp-version-number { font-size: 32px; font-weight: 700; color: var(--sp-primary); }
.sp-version-info p { color: var(--sp-text-muted); font-size: 13px; margin-top: 8px; }

.sp-card-meta { font-size: 12px; color: var(--sp-text-muted); }
</style>

<script>
jQuery(document).ready(function($) {
    // Integrität prüfen
    $('#sp-check-integrity').on('click', function() {
        var $btn = $(this);
        var $progress = $('#sp-integrity-progress');
        var $results = $('#sp-integrity-results');
        
        $btn.prop('disabled', true).text('Prüfe...');
        $progress.show();
        $('.sp-progress-fill').css('width', '30%');
        
        $.post(safetypress.ajax_url, {
            action: 'safetypress_check_integrity',
            nonce: safetypress.nonce
        }, function(response) {
            $('.sp-progress-fill').css('width', '100%');
            
            setTimeout(function() {
                $progress.hide();
                $btn.prop('disabled', false).text('🔍 Integrität prüfen');
                
                if (response.success) {
                    location.reload();
                } else {
                    alert('Fehler: ' + (response.data.message || 'Unbekannt'));
                }
            }, 500);
        });
    });
    
    // Einzelne Datei reparieren
    $(document).on('click', '.sp-repair-file', function() {
        var $btn = $(this);
        var $item = $btn.closest('.sp-file-item');
        var file = $item.data('file');
        
        if (!confirm('Datei "' + file + '" reparieren?\n\nEin Backup wird automatisch erstellt.')) {
            return;
        }
        
        $btn.prop('disabled', true).text('...');
        
        $.post(safetypress.ajax_url, {
            action: 'safetypress_repair_file',
            nonce: safetypress.nonce,
            file: file
        }, function(response) {
            if (response.success) {
                $item.addClass('repaired');
                $btn.text('✅ Repariert').prop('disabled', true);
            } else {
                alert('Fehler: ' + (response.data.message || 'Unbekannt'));
                $btn.prop('disabled', false).text('🔧 Reparieren');
            }
        });
    });
    
    // Alle reparieren
    $('#sp-repair-all').on('click', function() {
        if (!confirm('Alle modifizierten Dateien reparieren?\n\nBackups werden automatisch erstellt.')) {
            return;
        }
        
        var $btn = $(this);
        $btn.prop('disabled', true).text('Repariere...');
        
        $.post(safetypress.ajax_url, {
            action: 'safetypress_repair_all',
            nonce: safetypress.nonce
        }, function(response) {
            if (response.success) {
                var msg = '✅ Repariert (' + response.data.repaired.length + '):\n';
                if (response.data.repaired.length > 0) {
                    msg += response.data.repaired.join('\n') + '\n\n';
                } else {
                    msg += '(keine)\n\n';
                }
                
                if (response.data.failed.length > 0) {
                    msg += '❌ Fehlgeschlagen (' + response.data.failed.length + '):\n';
                    response.data.failed.forEach(function(f) {
                        msg += f.file + ': ' + f.error + '\n';
                    });
                }
                
                alert(msg);
                location.reload();
            } else {
                alert('Fehler beim Reparieren');
                $btn.prop('disabled', false).text('🔧 Alle reparieren');
            }
        });
    });
});
</script>
