<?php
if (!defined('ABSPATH')) exit;
$status = safetypress()->hardening ? safetypress()->hardening->get_status() : array();
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-header">
        <div class="sp-header-left">
            <div class="sp-logo">🛡️</div>
            <div class="sp-header-text">
                <h1>WordPress Hardening</h1>
                <p>Sicherheitshärtung & Best Practices</p>
            </div>
        </div>
        <div class="sp-header-right">
            <span class="sp-badge <?php echo get_option('safetypress_enable_hardening', 1) ? 'sp-badge-pro' : 'sp-badge-free'; ?>">
                <?php echo get_option('safetypress_enable_hardening', 1) ? '✓ Aktiv' : 'Inaktiv'; ?>
            </span>
        </div>
    </div>

    <!-- Navigation -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <div class="sp-grid">
        
        <!-- Hardening Options -->
        <div class="sp-col-8">
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon purple">⚙️</span>
                        Sicherheitsmaßnahmen
                    </h3>
                </div>
                
                <form method="post" action="options.php">
                    <?php settings_fields('safetypress_hardening'); ?>
                    
                    <div class="sp-module-list">
                        <!-- Hide WP Version -->
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-icon" style="background: linear-gradient(135deg, #3b82f6, #60a5fa);">🔒</div>
                                <div class="sp-module-info">
                                    <h4>WordPress-Version verbergen</h4>
                                    <p>Entfernt die WP-Version aus dem Quellcode</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_hide_wp_version" value="0">
                                <input type="checkbox" name="safetypress_hide_wp_version" value="1" <?php checked(get_option('safetypress_hide_wp_version', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                        
                        <!-- Disable XML-RPC -->
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-icon" style="background: linear-gradient(135deg, #ef4444, #f87171);">🚫</div>
                                <div class="sp-module-info">
                                    <h4>XML-RPC deaktivieren</h4>
                                    <p>Verhindert Remote-Angriffe via XML-RPC</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_disable_xmlrpc" value="0">
                                <input type="checkbox" name="safetypress_disable_xmlrpc" value="1" <?php checked(get_option('safetypress_disable_xmlrpc', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                        
                        <!-- Disable File Editor -->
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-icon" style="background: linear-gradient(135deg, #f97316, #fb923c);">📝</div>
                                <div class="sp-module-info">
                                    <h4>Datei-Editor deaktivieren</h4>
                                    <p>Verhindert Code-Bearbeitung im Admin</p>
                                </div>
                            </div>
                            <label class="sp-toggle">
                                <input type="hidden" name="safetypress_disable_file_editor" value="0">
                                <input type="checkbox" name="safetypress_disable_file_editor" value="1" <?php checked(get_option('safetypress_disable_file_editor', 1)); ?>>
                                <span class="sp-toggle-track"></span>
                            </label>
                        </div>
                        
                        <!-- Security Headers (Read-only) -->
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-icon" style="background: linear-gradient(135deg, #22c55e, #4ade80);">📋</div>
                                <div class="sp-module-info">
                                    <h4>Security Headers</h4>
                                    <p>X-Content-Type, X-Frame-Options, X-XSS-Protection</p>
                                </div>
                            </div>
                            <span class="sp-module-badge active">Immer aktiv</span>
                        </div>
                        
                        <!-- SSL Status (Read-only) -->
                        <div class="sp-module-item">
                            <div class="sp-module-left">
                                <div class="sp-module-icon" style="background: linear-gradient(135deg, <?php echo is_ssl() ? '#22c55e, #4ade80' : '#94a3b8, #94a3b8'; ?>);">🔐</div>
                                <div class="sp-module-info">
                                    <h4>SSL/HTTPS</h4>
                                    <p>Verschlüsselte Verbindung zur Website</p>
                                </div>
                            </div>
                            <span class="sp-module-badge <?php echo is_ssl() ? 'active' : 'inactive'; ?>">
                                <?php echo is_ssl() ? 'Aktiv' : 'Inaktiv'; ?>
                            </span>
                        </div>
                    </div>
                    
                    <div style="margin-top: 24px;">
                        <button type="submit" class="sp-btn sp-btn-primary">
                            💾 Einstellungen speichern
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Info Sidebar -->
        <div class="sp-col-4">
            <div class="sp-card">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon cyan">ℹ️</span>
                        Was ist Hardening?
                    </h3>
                </div>
                
                <p style="color: var(--sp-text-secondary); line-height: 1.7; margin-bottom: 24px;">
                    WordPress-Hardening schließt bekannte Sicherheitslücken und macht es Angreifern schwerer, Ihre Website zu kompromittieren.
                </p>
                
                <div class="sp-alert sp-alert-success">
                    <span class="sp-alert-icon">💡</span>
                    <div class="sp-alert-content">
                        <h4>Empfehlung</h4>
                        <p>Aktivieren Sie alle Optionen für maximale Sicherheit.</p>
                    </div>
                </div>
            </div>
            
            <div class="sp-card" style="margin-top: 24px;">
                <div class="sp-card-header">
                    <h3 class="sp-card-title">
                        <span class="sp-card-icon green">📊</span>
                        Status
                    </h3>
                </div>
                
                <?php
                $enabled_count = 0;
                if (get_option('safetypress_hide_wp_version', 1)) $enabled_count++;
                if (get_option('safetypress_disable_xmlrpc', 1)) $enabled_count++;
                if (get_option('safetypress_disable_file_editor', 1)) $enabled_count++;
                $enabled_count++; // Security Headers are always on
                if (is_ssl()) $enabled_count++;
                $total = 5;
                $percentage = round(($enabled_count / $total) * 100);
                ?>
                
                <div style="text-align: center; padding: 20px 0;">
                    <div style="font-size: 3rem; font-weight: 700; color: var(--sp-accent); line-height: 1;">
                        <?php echo $enabled_count; ?>/<?php echo $total; ?>
                    </div>
                    <p style="color: var(--sp-text-secondary); margin: 8px 0 0 0;">Maßnahmen aktiv</p>
                </div>
                
                <div class="sp-progress" style="margin-top: 16px;">
                    <div class="sp-progress-bar" style="width: <?php echo $percentage; ?>%;"></div>
                </div>
            </div>
        </div>

    </div>

</div>
