<?php
if (!defined('ABSPATH')) exit;

$blocked = safetypress()->firewall ? safetypress()->firewall->get_blocked_ips() : array();
$is_pro = function_exists('safetypress') && safetypress()->is_pro();
$countries = $is_pro && safetypress()->firewall ? safetypress()->firewall->get_all_countries() : array();
$blocked_countries = get_option('safetypress_fw_blocked_countries', array());
if (!is_array($blocked_countries)) $blocked_countries = array();

// Current tab
$current_tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'blocked';

// Helper function for flag emojis
function sp_get_flag_emoji($code) {
    $flags = array(
        'DE' => '🇩🇪', 'US' => '🇺🇸', 'GB' => '🇬🇧', 'FR' => '🇫🇷', 'ES' => '🇪🇸',
        'IT' => '🇮🇹', 'CN' => '🇨🇳', 'RU' => '🇷🇺', 'JP' => '🇯🇵', 'KR' => '🇰🇷',
        'BR' => '🇧🇷', 'IN' => '🇮🇳', 'AU' => '🇦🇺', 'CA' => '🇨🇦', 'NL' => '🇳🇱',
        'KP' => '🇰🇵', 'IR' => '🇮🇷', 'SY' => '🇸🇾', 'CU' => '🇨🇺', 'UA' => '🇺🇦',
        'AT' => '🇦🇹', 'CH' => '🇨🇭', 'PL' => '🇵🇱', 'SE' => '🇸🇪', 'NO' => '🇳🇴',
    );
    return isset($flags[$code]) ? $flags[$code] : '🏳️';
}
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-header">
        <div class="sp-header-left">
            <div class="sp-logo">🔥</div>
            <div class="sp-header-text">
                <h1>Firewall</h1>
                <p>Erweiterte Zugriffssteuerung & Schutz</p>
            </div>
        </div>
        <div class="sp-header-right">
            <span class="sp-badge <?php echo get_option('safetypress_enable_firewall', 1) ? 'sp-badge-pro' : 'sp-badge-free'; ?>">
                <?php echo get_option('safetypress_enable_firewall', 1) ? '✓ Aktiv' : 'Inaktiv'; ?>
            </span>
        </div>
    </div>

    <!-- Navigation -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <!-- Firewall Tabs -->
    <div class="sp-tabs">
        <a href="?page=safetypress-firewall&tab=blocked" class="sp-tab <?php echo $current_tab === 'blocked' ? 'active' : ''; ?>">
            🚫 Blockierte IPs
        </a>
        <a href="?page=safetypress-firewall&tab=ip-access" class="sp-tab <?php echo $current_tab === 'ip-access' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            🌐 IP-Zugriff <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
        <a href="?page=safetypress-firewall&tab=country" class="sp-tab <?php echo $current_tab === 'country' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            🗺️ Länder <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
        <a href="?page=safetypress-firewall&tab=bots" class="sp-tab <?php echo $current_tab === 'bots' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            🤖 Bots <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
        <a href="?page=safetypress-firewall&tab=urls" class="sp-tab <?php echo $current_tab === 'urls' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            🔗 URLs <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
        <a href="?page=safetypress-firewall&tab=roles" class="sp-tab <?php echo $current_tab === 'roles' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            👥 Rollen <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
        <a href="?page=safetypress-firewall&tab=rate-limit" class="sp-tab <?php echo $current_tab === 'rate-limit' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            ⏱️ Rate Limit <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
        <a href="?page=safetypress-firewall&tab=antispam" class="sp-tab <?php echo $current_tab === 'antispam' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            🛡️ Antispam <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
        <a href="?page=safetypress-firewall&tab=uploads" class="sp-tab <?php echo $current_tab === 'uploads' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            📁 Uploads <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
        <a href="?page=safetypress-firewall&tab=advanced" class="sp-tab <?php echo $current_tab === 'advanced' ? 'active' : ''; ?> <?php echo !$is_pro ? 'pro-required' : ''; ?>">
            ⚡ Erweitert <?php if (!$is_pro): ?><span class="sp-pro-tag">PRO</span><?php endif; ?>
        </a>
    </div>

    <!-- Tab Content -->
    <div class="sp-tab-content">
        
        <?php if ($current_tab === 'blocked'): ?>
        <!-- ==================== BLOCKED IPs TAB ==================== -->
        <div class="sp-grid">
            
            <!-- Block IP Form -->
            <div class="sp-col-4">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon red">🚫</span>
                            IP blockieren
                        </h3>
                    </div>
                    <form id="safetypress-block-ip-form">
                        <div class="sp-form-group">
                            <label class="sp-form-label">IP-Adresse</label>
                            <input type="text" id="block-ip" class="sp-form-input" placeholder="z.B. 192.168.1.1">
                            <p class="sp-form-hint">Unterstützt: Einzelne IP, CIDR (192.168.1.0/24), Wildcard (192.168.1.*)</p>
                        </div>
                        <div class="sp-form-group">
                            <label class="sp-form-label">Grund (optional)</label>
                            <input type="text" id="block-reason" class="sp-form-input" placeholder="z.B. Spam-Bot">
                        </div>
                        <div class="sp-form-group">
                            <label class="sp-toggle">
                                <input type="checkbox" id="block-permanent">
                                <span class="sp-toggle-track"></span>
                                <span class="sp-toggle-label">Permanent blockieren</span>
                            </label>
                        </div>
                        <button type="submit" class="sp-btn sp-btn-primary sp-btn-block">
                            🚫 IP blockieren
                        </button>
                    </form>
                </div>
                
                <!-- Stats -->
                <div class="sp-card" style="margin-top: 20px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon blue">📊</span>
                            Statistiken
                        </h3>
                    </div>
                    <div class="sp-stats-mini">
                        <div class="sp-stat-mini-item">
                            <span class="sp-stat-mini-value"><?php echo count($blocked); ?></span>
                            <span class="sp-stat-mini-label">Gesamt</span>
                        </div>
                        <div class="sp-stat-mini-item">
                            <span class="sp-stat-mini-value"><?php echo count(array_filter($blocked, function($b) { return $b->is_permanent; })); ?></span>
                            <span class="sp-stat-mini-label">Permanent</span>
                        </div>
                        <div class="sp-stat-mini-item">
                            <span class="sp-stat-mini-value"><?php echo count(array_filter($blocked, function($b) { return !$b->is_permanent; })); ?></span>
                            <span class="sp-stat-mini-label">Temporär</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Blocked IPs List -->
            <div class="sp-col-8">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon orange">📋</span>
                            Blockierte IPs
                        </h3>
                    </div>
                    <?php if (empty($blocked)): ?>
                        <div class="sp-empty">
                            <div class="sp-empty-icon">✅</div>
                            <p class="sp-empty-text">Keine IPs blockiert.</p>
                        </div>
                    <?php else: ?>
                        <div class="sp-table-wrap">
                            <table class="sp-table">
                                <thead>
                                    <tr>
                                        <th>IP-Adresse</th>
                                        <th>Grund</th>
                                        <th>Status</th>
                                        <th>Blockiert am</th>
                                        <th>Aktion</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($blocked as $ip): ?>
                                    <tr>
                                        <td><code><?php echo esc_html($ip->ip_address); ?></code></td>
                                        <td><?php echo esc_html($ip->reason ?: '-'); ?></td>
                                        <td>
                                            <?php if ($ip->is_permanent): ?>
                                                <span class="sp-table-badge critical">Permanent</span>
                                            <?php else: ?>
                                                <span class="sp-table-badge warning">Bis <?php echo date('d.m. H:i', strtotime($ip->blocked_until)); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo date('d.m.Y H:i', strtotime($ip->created_at)); ?></td>
                                        <td>
                                            <button class="sp-btn-small sp-btn-danger safetypress-unblock-ip" data-ip="<?php echo esc_attr($ip->ip_address); ?>">
                                                Entsperren
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <?php elseif ($current_tab === 'ip-access' && $is_pro): ?>
        <!-- ==================== IP ACCESS TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-6">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon green">✅</span>
                            IP Whitelist
                        </h3>
                    </div>
                    <p class="sp-card-desc">Diese IPs werden niemals blockiert und umgehen alle Firewall-Regeln.</p>
                    <div class="sp-form-group">
                        <textarea id="fw-ip-whitelist" class="sp-form-textarea" rows="10" placeholder="Eine IP pro Zeile&#10;192.168.1.1&#10;10.0.0.0/8&#10;172.16.*.*"><?php echo esc_textarea(get_option('safetypress_fw_ip_whitelist', '')); ?></textarea>
                    </div>
                    <p class="sp-form-hint">Unterstützt: Einzelne IPs, CIDR-Notation (192.168.1.0/24), Wildcards (192.168.1.*)</p>
                </div>
            </div>
            <div class="sp-col-6">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon red">🚫</span>
                            IP Blacklist
                        </h3>
                    </div>
                    <p class="sp-card-desc">Diese IPs werden sofort blockiert ohne weitere Prüfung.</p>
                    <div class="sp-form-group">
                        <textarea id="fw-ip-blacklist" class="sp-form-textarea" rows="10" placeholder="Eine IP pro Zeile&#10;Bekannte Angreifer&#10;Spam-Netzwerke"><?php echo esc_textarea(get_option('safetypress_fw_ip_blacklist', '')); ?></textarea>
                    </div>
                    <p class="sp-form-hint">Tipp: Importieren Sie bekannte Spam-IP-Listen für besseren Schutz.</p>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-ip-access">💾 Einstellungen speichern</button>
        </div>

        <?php elseif ($current_tab === 'country' && $is_pro): ?>
        <!-- ==================== COUNTRY TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-8">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon blue">🗺️</span>
                            Länder-basierte Zugriffskontrolle
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-country-blocking" <?php checked(get_option('safetypress_fw_country_blocking', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    <p class="sp-card-desc">Blockieren Sie Zugriffe aus bestimmten Ländern via Geo-IP-Lokalisierung.</p>
                    
                    <div class="sp-country-grid">
                        <?php foreach ($countries as $code => $name): ?>
                        <label class="sp-country-item <?php echo in_array($code, $blocked_countries) ? 'blocked' : ''; ?>">
                            <input type="checkbox" name="blocked_countries[]" value="<?php echo esc_attr($code); ?>" 
                                   <?php checked(in_array($code, $blocked_countries)); ?>>
                            <span class="sp-country-flag"><?php echo sp_get_flag_emoji($code); ?></span>
                            <span class="sp-country-name"><?php echo esc_html($name); ?></span>
                            <span class="sp-country-code"><?php echo esc_html($code); ?></span>
                        </label>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div class="sp-col-4">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon orange">🔍</span>
                            IP-Land testen
                        </h3>
                    </div>
                    <div class="sp-form-group">
                        <label class="sp-form-label">IP-Adresse</label>
                        <input type="text" id="test-ip-country" class="sp-form-input" placeholder="z.B. 8.8.8.8">
                    </div>
                    <button class="sp-btn sp-btn-secondary sp-btn-block" id="btn-test-country">
                        🔍 Land ermitteln
                    </button>
                    <div id="country-test-result" style="margin-top: 15px; display: none;">
                        <div class="sp-alert sp-alert-info">
                            <span id="country-result-text"></span>
                        </div>
                    </div>
                </div>
                
                <div class="sp-card" style="margin-top: 20px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon red">⚠️</span>
                            Hochrisiko-Länder
                        </h3>
                    </div>
                    <p class="sp-card-desc">Schnellauswahl für bekannte Hochrisiko-Länder:</p>
                    <button class="sp-btn sp-btn-danger sp-btn-block" id="btn-select-high-risk">
                        Hochrisiko-Länder auswählen
                    </button>
                    <p class="sp-form-hint" style="margin-top: 10px;">Wählt: RU, CN, KP, IR, SY, CU</p>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-country-settings">💾 Einstellungen speichern</button>
        </div>

        <?php elseif ($current_tab === 'bots' && $is_pro): ?>
        <!-- ==================== BOTS TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-8">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon purple">🤖</span>
                            Bot-Zugriffskontrolle
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-bot-blocking" <?php checked(get_option('safetypress_fw_bot_blocking', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    <p class="sp-card-desc">Blockieren Sie unerwünschte Bots anhand ihres User-Agents.</p>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Blockierte Bot User-Agents</label>
                        <textarea id="fw-blocked-bots" class="sp-form-textarea" rows="12" placeholder="Ein Bot-Name pro Zeile&#10;ahrefsbot&#10;semrushbot&#10;mj12bot"><?php echo esc_textarea(get_option('safetypress_fw_blocked_bots', "ahrefsbot\nsemrushbot\ndotbot\nmj12bot\nblexbot\npetalbot\nbytespider")); ?></textarea>
                    </div>
                    <p class="sp-form-hint">Geben Sie Teile des User-Agent-Strings ein. Groß-/Kleinschreibung wird ignoriert.</p>
                    
                    <div class="sp-form-group" style="margin-top: 20px;">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-block-empty-ua" <?php checked(get_option('safetypress_fw_block_empty_ua', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Leere User-Agents blockieren</span>
                        </label>
                        <p class="sp-form-hint">Blockiert Anfragen ohne User-Agent (oft Bots oder Angriffs-Tools).</p>
                    </div>
                </div>
            </div>
            <div class="sp-col-4">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon green">✅</span>
                            Erlaubte Bots
                        </h3>
                    </div>
                    <p class="sp-card-desc">Diese Bots werden niemals blockiert:</p>
                    <div class="sp-form-group">
                        <textarea id="fw-allowed-bots" class="sp-form-textarea" rows="8" placeholder="googlebot&#10;bingbot&#10;facebookexternalhit"><?php echo esc_textarea(get_option('safetypress_fw_allowed_bots', "googlebot\nbingbot\nyandexbot\nduckduckbot\nfacebookexternalhit\ntwitterbot\nlinkedinbot")); ?></textarea>
                    </div>
                </div>
                
                <div class="sp-card" style="margin-top: 20px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon blue">📋</span>
                            Schnellaktionen
                        </h3>
                    </div>
                    <button class="sp-btn sp-btn-secondary sp-btn-block" id="btn-load-default-bots" style="margin-bottom: 10px;">
                        🔄 Standard-Liste laden
                    </button>
                    <button class="sp-btn sp-btn-secondary sp-btn-block" id="btn-load-aggressive-bots">
                        ⚡ Aggressive Liste laden
                    </button>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-bot-settings">💾 Einstellungen speichern</button>
        </div>

        <?php elseif ($current_tab === 'urls' && $is_pro): ?>
        <!-- ==================== URLs TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-8">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon red">🔗</span>
                            URL-basierte Zugriffskontrolle
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-url-blocking" <?php checked(get_option('safetypress_fw_url_blocking', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    <p class="sp-card-desc">Blockieren Sie Zugriffe auf bestimmte URLs oder URL-Muster.</p>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Blockierte URLs</label>
                        <textarea id="fw-blocked-urls" class="sp-form-textarea" rows="12" placeholder="Ein Muster pro Zeile&#10;/xmlrpc.php&#10;*.sql&#10;/backup/*"><?php echo esc_textarea(get_option('safetypress_fw_blocked_urls', '')); ?></textarea>
                    </div>
                    <p class="sp-form-hint">
                        Unterstützte Formate:<br>
                        • Exakt: <code>/admin/secret.php</code><br>
                        • Wildcard: <code>/backup/*</code> oder <code>*.sql</code><br>
                        • Regex: <code>/\/(backup|dump)\.sql$/</code>
                    </p>
                </div>
            </div>
            <div class="sp-col-4">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon orange">💡</span>
                            Empfohlene Blockierungen
                        </h3>
                    </div>
                    <p class="sp-card-desc">Häufig angegriffene URLs:</p>
                    <div class="sp-url-suggestions">
                        <button class="sp-suggestion-btn" data-url="/xmlrpc.php">xmlrpc.php</button>
                        <button class="sp-suggestion-btn" data-url="*.sql">SQL Dumps</button>
                        <button class="sp-suggestion-btn" data-url="/.env">.env Dateien</button>
                        <button class="sp-suggestion-btn" data-url="/.git/*">.git Ordner</button>
                        <button class="sp-suggestion-btn" data-url="/wp-config.php.bak">Config Backups</button>
                        <button class="sp-suggestion-btn" data-url="*.tar.gz">Archive</button>
                    </div>
                </div>
                
                <div class="sp-card" style="margin-top: 20px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon green">✅</span>
                            URL Whitelist
                        </h3>
                    </div>
                    <div class="sp-form-group">
                        <textarea id="fw-whitelisted-urls" class="sp-form-textarea" rows="6" placeholder="URLs die nie blockiert werden"><?php echo esc_textarea(get_option('safetypress_fw_whitelisted_urls', '')); ?></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-url-settings">💾 Einstellungen speichern</button>
        </div>

        <?php elseif ($current_tab === 'roles' && $is_pro): ?>
        <!-- ==================== ROLES TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-12">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon purple">👥</span>
                            Rollen-basierte Zugriffskontrolle
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-role-access" <?php checked(get_option('safetypress_fw_role_access', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    <p class="sp-card-desc">Beschränken Sie den Zugriff auf bestimmte URLs basierend auf Benutzerrollen.</p>
                    
                    <div class="sp-role-rules" id="role-rules-container">
                        <?php 
                        $role_restrictions = get_option('safetypress_fw_role_restrictions', array());
                        if (empty($role_restrictions)) {
                            $role_restrictions = array(array('url' => '', 'roles' => ''));
                        }
                        foreach ($role_restrictions as $index => $rule): 
                        ?>
                        <div class="sp-role-rule" data-index="<?php echo $index; ?>">
                            <div class="sp-role-rule-content">
                                <div class="sp-form-group">
                                    <label class="sp-form-label">URL-Muster</label>
                                    <input type="text" class="sp-form-input rule-url" value="<?php echo esc_attr($rule['url']); ?>" placeholder="/wp-admin/plugins.php">
                                </div>
                                <div class="sp-form-group">
                                    <label class="sp-form-label">Erlaubte Rollen (kommagetrennt)</label>
                                    <input type="text" class="sp-form-input rule-roles" value="<?php echo esc_attr($rule['roles']); ?>" placeholder="administrator, editor">
                                </div>
                            </div>
                            <button class="sp-btn-icon sp-btn-danger remove-role-rule">✕</button>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <button class="sp-btn sp-btn-secondary" id="add-role-rule" style="margin-top: 15px;">
                        ➕ Regel hinzufügen
                    </button>
                    
                    <div class="sp-info-box" style="margin-top: 20px;">
                        <h4>Verfügbare WordPress-Rollen:</h4>
                        <p><code>administrator</code>, <code>editor</code>, <code>author</code>, <code>contributor</code>, <code>subscriber</code></p>
                    </div>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-role-settings">💾 Einstellungen speichern</button>
        </div>

        <?php elseif ($current_tab === 'rate-limit' && $is_pro): ?>
        <!-- ==================== RATE LIMIT TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-8">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon orange">⏱️</span>
                            Rate Limiting
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-rate-limiting" <?php checked(get_option('safetypress_fw_rate_limiting', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    <p class="sp-card-desc">Begrenzen Sie die Anzahl der Anfragen pro IP um aggressive Bots und DDoS-Angriffe zu blockieren.</p>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Maximale Anfragen pro Minute</label>
                        <input type="number" id="fw-rate-limit" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_fw_rate_limit', 60)); ?>" min="10" max="500">
                        <p class="sp-form-hint">Empfohlen: 60-120 für normale Websites.</p>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Auto-Block nach Überschreitungen</label>
                        <input type="number" id="fw-rate-limit-block-after" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_fw_rate_limit_block_after', 3)); ?>" min="1" max="10">
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Auto-Block Dauer</label>
                        <select id="fw-rate-limit-block-duration" class="sp-form-select">
                            <option value="900" <?php selected(get_option('safetypress_fw_rate_limit_block_duration', 3600), 900); ?>>15 Minuten</option>
                            <option value="1800" <?php selected(get_option('safetypress_fw_rate_limit_block_duration', 3600), 1800); ?>>30 Minuten</option>
                            <option value="3600" <?php selected(get_option('safetypress_fw_rate_limit_block_duration', 3600), 3600); ?>>1 Stunde</option>
                            <option value="86400" <?php selected(get_option('safetypress_fw_rate_limit_block_duration', 3600), 86400); ?>>24 Stunden</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="sp-col-4">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon green">✅</span>
                            Ausnahmen
                        </h3>
                    </div>
                    <div class="sp-form-group">
                        <textarea id="fw-rate-limit-exclude" class="sp-form-textarea" rows="6" placeholder="/wp-cron.php&#10;/wp-admin/admin-ajax.php"><?php echo esc_textarea(get_option('safetypress_fw_rate_limit_exclude', "/wp-cron.php\n/wp-admin/admin-ajax.php")); ?></textarea>
                    </div>
                </div>
                
                <div class="sp-card" style="margin-top: 20px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon blue">📊</span>
                            Empfehlungen
                        </h3>
                    </div>
                    <div class="sp-recommendations">
                        <div class="sp-rec-item"><span class="sp-rec-type">Blog:</span><span class="sp-rec-value">120/min</span></div>
                        <div class="sp-rec-item"><span class="sp-rec-type">Shop:</span><span class="sp-rec-value">180/min</span></div>
                        <div class="sp-rec-item"><span class="sp-rec-type">API:</span><span class="sp-rec-value">60/min</span></div>
                    </div>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-rate-limit-settings">💾 Einstellungen speichern</button>
        </div>

        <?php elseif ($current_tab === 'antispam' && $is_pro): ?>
        <!-- ==================== ANTISPAM TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-6">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon green">💬</span>
                            Kommentar-Antispam
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-antispam" <?php checked(get_option('safetypress_fw_antispam', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-antispam-honeypot" <?php checked(get_option('safetypress_fw_antispam_honeypot', 1), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Honeypot-Feld aktivieren</span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-antispam-timing" <?php checked(get_option('safetypress_fw_antispam_timing', 1), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Zeit-basierte Prüfung</span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Max. Links pro Kommentar</label>
                        <input type="number" id="fw-spam-max-links" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_fw_spam_max_links', 3)); ?>" min="0" max="20">
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Blacklist-Wörter</label>
                        <textarea id="fw-spam-blacklist" class="sp-form-textarea" rows="6" placeholder="viagra&#10;casino&#10;loan"><?php echo esc_textarea(get_option('safetypress_fw_spam_blacklist', '')); ?></textarea>
                    </div>
                </div>
            </div>
            <div class="sp-col-6">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon blue">👤</span>
                            Registrierungs-Antispam
                        </h3>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-block-disposable-email" <?php checked(get_option('safetypress_fw_block_disposable_email', 1), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Einweg-E-Mails blockieren</span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Zusätzliche blockierte E-Mail-Domains</label>
                        <textarea id="fw-blocked-email-domains" class="sp-form-textarea" rows="6" placeholder="spammail.com&#10;fakemail.net"><?php echo esc_textarea(get_option('safetypress_fw_blocked_email_domains', '')); ?></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-antispam-settings">💾 Einstellungen speichern</button>
        </div>

        <?php elseif ($current_tab === 'uploads' && $is_pro): ?>
        <!-- ==================== UPLOADS TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-8">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon blue">📁</span>
                            Datei-Upload Sicherheit
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-upload-filter" <?php checked(get_option('safetypress_fw_upload_filter', 1), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Maximale Dateigröße (MB)</label>
                        <input type="number" id="fw-max-upload-size" class="sp-form-input" value="<?php echo esc_attr(get_option('safetypress_fw_max_upload_size', 10)); ?>" min="1" max="100">
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Blockierte Dateierweiterungen</label>
                        <textarea id="fw-blocked-extensions" class="sp-form-textarea" rows="4"><?php 
                        $default_ext = implode("\n", array('ph'.'p', 'ph'.'tml', 'ph'.'p3', 'ph'.'p4', 'ph'.'p5', 'ex'.'e', 's'.'h', 'ba'.'t'));
                        echo esc_textarea(get_option('safetypress_fw_blocked_extensions', $default_ext)); 
                        ?></textarea>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-check-double-extension" <?php checked(get_option('safetypress_fw_check_double_extension', 1), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Doppelte Erweiterungen prüfen (z.B. image.php.jpg)</span>
                        </label>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-scan-upload-content" <?php checked(get_option('safetypress_fw_scan_upload_content', 1), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Dateiinhalt auf PHP-Code prüfen</span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="sp-col-4">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon green">✅</span>
                            Erlaubte MIME-Types
                        </h3>
                    </div>
                    <div class="sp-form-group">
                        <textarea id="fw-allowed-mime-types" class="sp-form-textarea" rows="10"><?php echo esc_textarea(get_option('safetypress_fw_allowed_mime_types', "image/jpeg\nimage/png\nimage/gif\napplication/pdf")); ?></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-upload-settings">💾 Einstellungen speichern</button>
        </div>

        <?php elseif ($current_tab === 'advanced' && $is_pro): ?>
        <!-- ==================== ADVANCED TAB (PRO) ==================== -->
        <div class="sp-grid">
            <div class="sp-col-6">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon orange">⚡</span>
                            Performance
                        </h3>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-shared-memory" <?php checked(get_option('safetypress_fw_shared_memory', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Unix Shared Memory nutzen</span>
                        </label>
                        <p class="sp-form-hint">Für schnellere Inter-Prozess-Kommunikation. Erfordert PHP shmop.</p>
                    </div>
                    
                    <div class="sp-form-group">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-cache-geo" <?php checked(get_option('safetypress_fw_cache_geo', 1), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Geo-IP Ergebnisse cachen</span>
                        </label>
                    </div>
                </div>
                
                <div class="sp-card" style="margin-top: 20px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon purple">🔍</span>
                            Response Body Filter
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-response-filter" <?php checked(get_option('safetypress_fw_response_filter', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    <p class="sp-card-desc">Scannt HTML-Output vor dem Senden an den Browser.</p>
                    
                    <div class="sp-form-group">
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-response-filter-remove" <?php checked(get_option('safetypress_fw_response_filter_remove', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Verdächtigen Code entfernen</span>
                        </label>
                    </div>
                </div>
            </div>
            
            <div class="sp-col-6">
                <div class="sp-card">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon blue">📋</span>
                            Syslog Logging
                        </h3>
                        <label class="sp-toggle">
                            <input type="checkbox" id="fw-syslog" <?php checked(get_option('safetypress_fw_syslog', 0), 1); ?>>
                            <span class="sp-toggle-track"></span>
                            <span class="sp-toggle-label">Aktiviert</span>
                        </label>
                    </div>
                    <p class="sp-card-desc">Sendet Firewall-Events an System-Syslog.</p>
                    
                    <div class="sp-form-group">
                        <label class="sp-form-label">Syslog Facility</label>
                        <select id="fw-syslog-facility" class="sp-form-select">
                            <option value="128" <?php selected(get_option('safetypress_fw_syslog_facility', 128), 128); ?>>LOG_LOCAL0</option>
                            <option value="136" <?php selected(get_option('safetypress_fw_syslog_facility', 128), 136); ?>>LOG_LOCAL1</option>
                            <option value="80" <?php selected(get_option('safetypress_fw_syslog_facility', 128), 80); ?>>LOG_AUTH</option>
                        </select>
                    </div>
                </div>
                
                <div class="sp-card" style="margin-top: 20px;">
                    <div class="sp-card-header">
                        <h3 class="sp-card-title">
                            <span class="sp-card-icon red">🎨</span>
                            Benutzerdefinierte Block-Seite
                        </h3>
                    </div>
                    <div class="sp-form-group">
                        <textarea id="fw-block-page" class="sp-form-textarea" rows="6" placeholder="<h1>Zugriff verweigert</h1>"><?php echo esc_textarea(get_option('safetypress_fw_block_page', '')); ?></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; text-align: right;">
            <button class="sp-btn sp-btn-primary" id="save-advanced-settings">💾 Einstellungen speichern</button>
        </div>

        <?php elseif (!$is_pro && $current_tab !== 'blocked'): ?>
        <!-- ==================== PRO REQUIRED ==================== -->
        <div class="sp-card">
            <div class="sp-pro-required-box">
                <div class="sp-pro-icon">🔒</div>
                <h2>Pro-Feature</h2>
                <p>Diese Funktion ist nur in SafetyPress Pro verfügbar.</p>
                <ul class="sp-pro-features-list">
                    <li>✓ IP-basierte Zugriffskontrolle (Whitelist/Blacklist)</li>
                    <li>✓ Länder-basiertes Blocking via Geo-IP</li>
                    <li>✓ Bot & User-Agent Kontrolle</li>
                    <li>✓ URL-basiertes Blocking</li>
                    <li>✓ Rollen-basierte Zugriffssteuerung</li>
                    <li>✓ Rate Limiting gegen DDoS</li>
                    <li>✓ Antispam für Kommentare & Registrierung</li>
                    <li>✓ Erweiterte Upload-Sicherheit</li>
                    <li>✓ Response Body Filter</li>
                    <li>✓ Syslog Integration</li>
                    <li>✓ Unix Shared Memory Performance</li>
                </ul>
                <a href="<?php echo admin_url('admin.php?page=safetypress-license'); ?>" class="sp-btn sp-btn-primary sp-btn-lg">
                    🚀 Jetzt auf Pro upgraden
                </a>
            </div>
        </div>
        <?php endif; ?>
        
    </div>
</div>

<style>
.sp-tabs{display:flex;flex-wrap:wrap;gap:8px;margin-bottom:24px;padding:16px;background:#1e293b;border:1px solid #334155;border-radius:14px}
.sp-tab{display:inline-flex;align-items:center;gap:6px;padding:10px 16px;background:#0f172a;border:1px solid #334155;border-radius:8px;color:#94a3b8;text-decoration:none;font-size:.85rem;transition:all .3s ease}
.sp-tab:hover{background:#334155;color:#f1f5f9}
.sp-tab.active{background:linear-gradient(135deg,#22c55e,#10b981);border-color:transparent;color:#000;font-weight:600}
.sp-tab .sp-pro-tag{font-size:.65rem;padding:2px 6px;background:rgba(251,191,36,.2);color:#fbbf24;border-radius:4px;font-weight:700}
.sp-tab.active .sp-pro-tag{background:rgba(0,0,0,.2);color:#000}
.sp-country-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(200px,1fr));gap:8px;max-height:400px;overflow-y:auto;padding:10px;background:#0f172a;border-radius:8px}
.sp-country-item{display:flex;align-items:center;gap:8px;padding:8px 12px;background:#1e293b;border:1px solid #334155;border-radius:6px;cursor:pointer;transition:all .2s ease}
.sp-country-item:hover{border-color:#475569}
.sp-country-item.blocked,.sp-country-item:has(input:checked){background:rgba(239,68,68,.1);border-color:#ef4444}
.sp-country-item input{display:none}
.sp-country-flag{font-size:1.2rem}
.sp-country-name{flex:1;color:#f1f5f9;font-size:.85rem}
.sp-country-code{color:#94a3b8;font-size:.75rem;font-family:monospace}
.sp-url-suggestions{display:flex;flex-wrap:wrap;gap:8px}
.sp-suggestion-btn{padding:6px 12px;background:#0f172a;border:1px solid #334155;border-radius:6px;color:#94a3b8;font-size:.8rem;cursor:pointer;transition:all .2s ease}
.sp-suggestion-btn:hover{border-color:#22c55e;color:#22c55e}
.sp-role-rule{display:flex;gap:15px;padding:15px;background:#0f172a;border:1px solid #334155;border-radius:8px;margin-bottom:10px;align-items:flex-end}
.sp-role-rule-content{flex:1;display:grid;grid-template-columns:1fr 1fr;gap:15px}
.sp-btn-icon{width:40px;height:40px;display:flex;align-items:center;justify-content:center;background:rgba(239,68,68,.1);border:1px solid rgba(239,68,68,.3);border-radius:8px;color:#ef4444;cursor:pointer;transition:all .2s ease}
.sp-btn-icon:hover{background:#ef4444;color:#fff}
.sp-stats-mini{display:grid;grid-template-columns:repeat(3,1fr);gap:10px}
.sp-stat-mini-item{text-align:center;padding:15px 10px;background:#0f172a;border-radius:8px}
.sp-stat-mini-value{display:block;font-size:1.5rem;font-weight:700;color:#f1f5f9}
.sp-stat-mini-label{display:block;font-size:.75rem;color:#94a3b8;margin-top:4px}
.sp-recommendations{display:flex;flex-direction:column;gap:8px}
.sp-rec-item{display:flex;justify-content:space-between;padding:10px;background:#0f172a;border-radius:6px}
.sp-rec-type{color:#94a3b8}
.sp-rec-value{color:#22c55e;font-weight:600;font-family:monospace}
.sp-pro-required-box{text-align:center;padding:60px 40px}
.sp-pro-icon{font-size:4rem;margin-bottom:20px}
.sp-pro-required-box h2{color:#f1f5f9;font-size:1.8rem;margin-bottom:10px}
.sp-pro-required-box p{color:#94a3b8;margin-bottom:30px}
.sp-pro-features-list{display:inline-block;text-align:left;margin-bottom:30px;list-style:none;padding:0}
.sp-pro-features-list li{color:#f1f5f9;padding:8px 0;border-bottom:1px solid #334155}
.sp-btn-lg{padding:16px 32px!important;font-size:1rem!important}
.sp-info-box{padding:15px;background:rgba(59,130,246,.1);border:1px solid rgba(59,130,246,.3);border-radius:8px}
.sp-info-box h4{color:#3b82f6;margin:0 0 8px;font-size:.9rem}
.sp-info-box p{color:#94a3b8;margin:0;font-size:.85rem}
.sp-info-box code{background:#0f172a;padding:2px 6px;border-radius:4px;color:#22c55e}
.sp-form-textarea{width:100%;padding:12px;background:#0f172a;border:1px solid #334155;border-radius:8px;color:#f1f5f9;font-family:Consolas,monospace;font-size:.9rem;resize:vertical}
.sp-form-textarea:focus{outline:none;border-color:#22c55e}
.sp-form-select{width:100%;padding:12px;background:#0f172a;border:1px solid #334155;border-radius:8px;color:#f1f5f9;font-size:.9rem}
.sp-form-hint{color:#94a3b8;font-size:.8rem;margin-top:6px}
.sp-card-desc{color:#94a3b8;font-size:.9rem;margin-bottom:20px}
.sp-btn-block{width:100%}
.sp-btn-small{padding:6px 12px;font-size:.8rem;background:transparent;border:1px solid #ef4444;color:#ef4444;border-radius:6px;cursor:pointer;transition:all .2s ease}
.sp-btn-small:hover{background:#ef4444;color:#fff}
</style>

<script>
jQuery(document).ready(function($) {
    var nonce = '<?php echo wp_create_nonce('safetypress_admin'); ?>';
    
    $('#safetypress-block-ip-form').on('submit', function(e) {
        e.preventDefault();
        var $btn = $(this).find('button[type="submit"]');
        $btn.prop('disabled', true).text('Blockiere...');
        $.post(ajaxurl, {action:'safetypress_block_ip',nonce:nonce,ip:$('#block-ip').val(),reason:$('#block-reason').val(),permanent:$('#block-permanent').is(':checked')?'true':'false'}, function(r) {
            if(r.success) location.reload(); else { alert(r.data.message); $btn.prop('disabled',false).text('🚫 IP blockieren'); }
        });
    });
    
    $('.safetypress-unblock-ip').on('click', function() {
        if(!confirm('IP wirklich entsperren?')) return;
        $.post(ajaxurl, {action:'safetypress_unblock_ip',nonce:nonce,ip:$(this).data('ip')}, function(r) { if(r.success) location.reload(); else alert(r.data.message); });
    });
    
    $('.sp-country-item').on('click', function(e) {
        if(e.target.tagName !== 'INPUT') { var $c = $(this).find('input'); $c.prop('checked', !$c.is(':checked')); }
        $(this).toggleClass('blocked', $(this).find('input').is(':checked'));
    });
    
    $('#btn-test-country').on('click', function() {
        var ip = $('#test-ip-country').val();
        if(!ip) return alert('Bitte IP eingeben');
        $.post(ajaxurl, {action:'safetypress_test_ip_country',nonce:nonce,ip:ip}, function(r) {
            if(r.success) { $('#country-result-text').text(ip + ' → ' + r.data.country_name + ' (' + r.data.country_code + ')'); $('#country-test-result').show(); }
            else alert(r.data.message);
        });
    });
    
    $('#btn-select-high-risk').on('click', function() {
        ['RU','CN','KP','IR','SY','CU'].forEach(function(c) { var $i = $('.sp-country-item input[value="'+c+'"]'); $i.prop('checked',true); $i.closest('.sp-country-item').addClass('blocked'); });
    });
    
    $('.sp-suggestion-btn').on('click', function() {
        var $t = $('#fw-blocked-urls'), c = $t.val();
        if(c && !c.endsWith('\n')) c += '\n';
        $t.val(c + $(this).data('url'));
    });
    
    $('#add-role-rule').on('click', function() {
        var i = $('.sp-role-rule').length;
        $('#role-rules-container').append('<div class="sp-role-rule" data-index="'+i+'"><div class="sp-role-rule-content"><div class="sp-form-group"><label class="sp-form-label">URL-Muster</label><input type="text" class="sp-form-input rule-url" placeholder="/wp-admin/plugins.php"></div><div class="sp-form-group"><label class="sp-form-label">Erlaubte Rollen</label><input type="text" class="sp-form-input rule-roles" placeholder="administrator, editor"></div></div><button class="sp-btn-icon sp-btn-danger remove-role-rule">✕</button></div>');
    });
    
    $(document).on('click', '.remove-role-rule', function() { $(this).closest('.sp-role-rule').remove(); });
    
    function saveSettings(s, m) {
        $.post(ajaxurl, {action:'safetypress_save_firewall_rules',nonce:nonce,settings:s}, function(r) { alert(r.success ? (m||'Gespeichert!') : 'Fehler: '+r.data.message); });
    }
    
    $('#save-ip-access').on('click', function() { saveSettings({ip_whitelist:$('#fw-ip-whitelist').val(),ip_blacklist:$('#fw-ip-blacklist').val()}); });
    $('#save-country-settings').on('click', function() { var c=[]; $('input[name="blocked_countries[]"]:checked').each(function(){c.push($(this).val());}); saveSettings({country_blocking:$('#fw-country-blocking').is(':checked')?1:0,blocked_countries:c}); });
    $('#save-bot-settings').on('click', function() { saveSettings({bot_blocking:$('#fw-bot-blocking').is(':checked')?1:0,blocked_bots:$('#fw-blocked-bots').val(),allowed_bots:$('#fw-allowed-bots').val(),block_empty_ua:$('#fw-block-empty-ua').is(':checked')?1:0}); });
    $('#save-url-settings').on('click', function() { saveSettings({url_blocking:$('#fw-url-blocking').is(':checked')?1:0,blocked_urls:$('#fw-blocked-urls').val(),whitelisted_urls:$('#fw-whitelisted-urls').val()}); });
    $('#save-role-settings').on('click', function() { var r=[]; $('.sp-role-rule').each(function(){var u=$(this).find('.rule-url').val(),ro=$(this).find('.rule-roles').val();if(u)r.push({url:u,roles:ro});}); saveSettings({role_access:$('#fw-role-access').is(':checked')?1:0,role_restrictions:r}); });
    $('#save-rate-limit-settings').on('click', function() { saveSettings({rate_limiting:$('#fw-rate-limiting').is(':checked')?1:0,rate_limit:$('#fw-rate-limit').val(),rate_limit_block_after:$('#fw-rate-limit-block-after').val(),rate_limit_block_duration:$('#fw-rate-limit-block-duration').val(),rate_limit_exclude:$('#fw-rate-limit-exclude').val()}); });
    $('#save-antispam-settings').on('click', function() { saveSettings({antispam:$('#fw-antispam').is(':checked')?1:0,antispam_honeypot:$('#fw-antispam-honeypot').is(':checked')?1:0,antispam_timing:$('#fw-antispam-timing').is(':checked')?1:0,spam_max_links:$('#fw-spam-max-links').val(),spam_blacklist:$('#fw-spam-blacklist').val(),block_disposable_email:$('#fw-block-disposable-email').is(':checked')?1:0,blocked_email_domains:$('#fw-blocked-email-domains').val()}); });
    $('#save-upload-settings').on('click', function() { saveSettings({upload_filter:$('#fw-upload-filter').is(':checked')?1:0,max_upload_size:$('#fw-max-upload-size').val(),blocked_extensions:$('#fw-blocked-extensions').val(),check_double_extension:$('#fw-check-double-extension').is(':checked')?1:0,scan_upload_content:$('#fw-scan-upload-content').is(':checked')?1:0,allowed_mime_types:$('#fw-allowed-mime-types').val()}); });
    $('#save-advanced-settings').on('click', function() { saveSettings({shared_memory:$('#fw-shared-memory').is(':checked')?1:0,cache_geo:$('#fw-cache-geo').is(':checked')?1:0,response_filter:$('#fw-response-filter').is(':checked')?1:0,response_filter_remove:$('#fw-response-filter-remove').is(':checked')?1:0,syslog:$('#fw-syslog').is(':checked')?1:0,syslog_facility:$('#fw-syslog-facility').val(),block_page:$('#fw-block-page').val()}); });
    
    $('#btn-load-default-bots').on('click', function() { $('#fw-blocked-bots').val("ahrefsbot\nsemrushbot\ndotbot\nmj12bot\nblexbot\npetalbot\nbytespider"); });
    $('#btn-load-aggressive-bots').on('click', function() { $('#fw-blocked-bots').val("ahrefsbot\nsemrushbot\ndotbot\nmj12bot\nblexbot\npetalbot\nbytespider\nclaudebot\ngptbot\nccbot\nscreaming frog\nsqlmap\nnikto\nnessus\nacunetix\nburpsuite\nwpscan"); });
});
</script>
