<?php
if (!defined('ABSPATH')) exit;

$score = SafetyPress_Helper::get_security_score();
$max_score = SafetyPress_Helper::get_max_score();
$pro_potential = SafetyPress_Helper::get_potential_pro_points();
$score_details = SafetyPress_Helper::get_score_details();
$is_pro = function_exists('safetypress') && safetypress()->is_pro();
$license_info = $is_pro && safetypress()->license ? safetypress()->license->get_license_info() : null;

// Get stats
$blocked_count = 0;
$login_attempts = 0;

if (safetypress()->firewall) {
    $blocked = safetypress()->firewall->get_blocked_ips();
    $blocked_count = is_array($blocked) ? count($blocked) : 0;
}

if (safetypress()->login_protection) {
    $stats = safetypress()->login_protection->get_statistics();
    $login_attempts = isset($stats['failed_attempts']) ? intval($stats['failed_attempts']) : 0;
}

// Get recent logs
$recent_logs = array();
if (safetypress()->logger) {
    $recent_logs = safetypress()->logger->get_logs(array('limit' => 5));
}

// Score calculation - jetzt mit max_score berücksichtigt
$circumference = 440;
$offset = $circumference - ($circumference * $score / 100);

$score_status = 'bad';
$score_text = 'Verbesserung nötig';
if ($is_pro) {
    // PRO User: normale Bewertung
    if ($score >= 70) {
        $score_status = 'good';
        $score_text = 'Gut geschützt';
    } elseif ($score >= 40) {
        $score_status = 'medium';
        $score_text = 'Teilweise geschützt';
    }
} else {
    // FREE User: angepasste Bewertung (max 70 möglich)
    if ($score >= 60) {
        $score_status = 'good';
        $score_text = 'Gut geschützt (Free)';
    } elseif ($score >= 35) {
        $score_status = 'medium';
        $score_text = 'Teilweise geschützt';
    }
}
?>

<div class="wrap safetypress-wrap">
    
    <!-- Header -->
    <div class="sp-dashboard-header">
        <div class="sp-header-brand">
            <div class="sp-logo-box">
                <svg width="32" height="32" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 2L3 7V12C3 17.55 6.84 22.74 12 24C17.16 22.74 21 17.55 21 12V7L12 2Z" fill="url(#shield-grad)"/>
                    <path d="M10 15.5L7.5 13L6.09 14.41L10 18.33L18 10.33L16.59 8.92L10 15.5Z" fill="white"/>
                    <defs>
                        <linearGradient id="shield-grad" x1="3" y1="2" x2="21" y2="24" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#22c55e"/>
                            <stop offset="1" stop-color="#10b981"/>
                        </linearGradient>
                    </defs>
                </svg>
            </div>
            <div class="sp-header-title">
                <h1>SafetyPress</h1>
                <span class="sp-header-subtitle">Security Dashboard</span>
            </div>
        </div>
        <div class="sp-header-actions">
            <?php if ($is_pro): ?>
                <span class="sp-pro-badge">
                    <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                    Pro aktiv
                </span>
            <?php else: ?>
                <span class="sp-free-badge">Free</span>
                <a href="<?php echo admin_url('admin.php?page=safetypress-license'); ?>" class="sp-upgrade-btn">Upgrade</a>
            <?php endif; ?>
        </div>
    </div>

    <!-- Navigation Tabs -->
    <?php include SAFETYPRESS_PLUGIN_DIR . 'admin/views/partials/navigation.php'; ?>

    <!-- Stats Cards -->
    <div class="sp-stats-grid">
        <div class="sp-stat-box">
            <div class="sp-stat-icon green">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2L3 7V12C3 17.55 6.84 22.74 12 24C17.16 22.74 21 17.55 21 12V7L12 2Z"/></svg>
            </div>
            <div class="sp-stat-content">
                <div class="sp-stat-number"><?php echo $score; ?>%</div>
                <div class="sp-stat-label">Security Score</div>
            </div>
        </div>
        <div class="sp-stat-box">
            <div class="sp-stat-icon red">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z"/></svg>
            </div>
            <div class="sp-stat-content">
                <div class="sp-stat-number"><?php echo number_format($blocked_count); ?></div>
                <div class="sp-stat-label">IPs blockiert</div>
            </div>
        </div>
        <div class="sp-stat-box">
            <div class="sp-stat-icon orange">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z"/></svg>
            </div>
            <div class="sp-stat-content">
                <div class="sp-stat-number"><?php echo number_format($login_attempts); ?></div>
                <div class="sp-stat-label">Login-Versuche (30d)</div>
            </div>
        </div>
        <div class="sp-stat-box">
            <div class="sp-stat-icon blue">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zm4.2 14.2L11 13V7h1.5v5.2l4.5 2.7-.8 1.3z"/></svg>
            </div>
            <div class="sp-stat-content">
                <div class="sp-stat-number">24/7</div>
                <div class="sp-stat-label">Schutz aktiv</div>
            </div>
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="sp-main-grid">
        
        <!-- Left Column: Score + Activity -->
        <div class="sp-main-left">
            
            <!-- Security Score Card -->
            <div class="sp-card sp-score-card">
                <div class="sp-card-head">
                    <h3>Security Score</h3>
                    <?php if (!$is_pro): ?>
                        <span class="sp-score-max-hint">Max. <?php echo $max_score; ?>% ohne Pro</span>
                    <?php endif; ?>
                </div>
                <div class="sp-score-display">
                    <div class="sp-score-circle">
                        <svg viewBox="0 0 180 180" width="160" height="160">
                            <defs>
                                <linearGradient id="scoreGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" stop-color="#22c55e"/>
                                    <stop offset="100%" stop-color="#3b82f6"/>
                                </linearGradient>
                                <linearGradient id="proGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" stop-color="#8b5cf6"/>
                                    <stop offset="100%" stop-color="#a855f7"/>
                                </linearGradient>
                            </defs>
                            <circle cx="90" cy="90" r="70" fill="none" stroke="#1e293b" stroke-width="12"/>
                            <?php if (!$is_pro && $pro_potential > 0): ?>
                                <!-- Gestrichelter PRO-Potential Ring -->
                                <circle cx="90" cy="90" r="70" fill="none" stroke="url(#proGrad)" stroke-width="12" stroke-linecap="round" 
                                    stroke-dasharray="<?php echo $circumference; ?>" 
                                    stroke-dashoffset="<?php echo $circumference - ($circumference * ($score + $pro_potential) / 100); ?>" 
                                    style="transform: rotate(-90deg); transform-origin: center; opacity: 0.3;"/>
                            <?php endif; ?>
                            <circle cx="90" cy="90" r="70" fill="none" stroke="url(#scoreGrad)" stroke-width="12" stroke-linecap="round" 
                                stroke-dasharray="<?php echo $circumference; ?>" 
                                stroke-dashoffset="<?php echo $offset; ?>" 
                                style="transform: rotate(-90deg); transform-origin: center;"/>
                        </svg>
                        <div class="sp-score-text">
                            <span class="sp-score-num"><?php echo $score; ?></span>
                            <span class="sp-score-max">/ <?php echo $is_pro ? '100' : $max_score; ?></span>
                        </div>
                    </div>
                    <div class="sp-score-badge <?php echo $score_status; ?>">
                        <?php if ($score_status === 'good'): ?>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <?php elseif ($score_status === 'medium'): ?>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"/></svg>
                        <?php else: ?>
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z"/></svg>
                        <?php endif; ?>
                        <?php echo $score_text; ?>
                    </div>
                    <?php if (!$is_pro && $pro_potential > 0): ?>
                        <div class="sp-pro-potential">
                            <a href="<?php echo admin_url('admin.php?page=safetypress-license'); ?>">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 14H7v-2h7v2zm3-4H7v-2h10v2zm0-4H7V7h10v2z"/></svg>
                                +<?php echo $pro_potential; ?>% mit Pro möglich
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Activity Log Card -->
            <div class="sp-card sp-activity-card">
                <div class="sp-card-head">
                    <h3>Letzte Aktivitäten</h3>
                    <a href="<?php echo admin_url('admin.php?page=safetypress-logs'); ?>" class="sp-card-action">Alle →</a>
                </div>
                <div class="sp-activity-feed">
                    <?php if (empty($recent_logs)): ?>
                        <div class="sp-empty-state">
                            <svg width="48" height="48" viewBox="0 0 24 24" fill="#475569"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 14H6v-2h6v2zm4-4H6v-2h10v2zm0-4H6V7h10v2z"/></svg>
                            <p>Noch keine Aktivitäten</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($recent_logs as $log): 
                            $icon_class = 'info';
                            $icon_svg = '<path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"/>';
                            if (strpos($log->event_type, 'block') !== false || strpos($log->event_type, 'fail') !== false || strpos($log->event_type, 'locked') !== false) {
                                $icon_class = 'error';
                                $icon_svg = '<path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z"/>';
                            } elseif (strpos($log->event_type, 'success') !== false || $log->event_type === 'login_success') {
                                $icon_class = 'success';
                                $icon_svg = '<path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>';
                            } elseif (strpos($log->event_type, 'scan') !== false) {
                                $icon_class = 'info';
                                $icon_svg = '<path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5z"/>';
                            }
                        ?>
                            <div class="sp-activity-row">
                                <div class="sp-activity-icon <?php echo $icon_class; ?>">
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><?php echo $icon_svg; ?></svg>
                                </div>
                                <div class="sp-activity-info">
                                    <div class="sp-activity-msg"><?php echo esc_html($log->event_message); ?></div>
                                    <div class="sp-activity-time"><?php echo esc_html(human_time_diff(strtotime($log->created_at), current_time('timestamp'))); ?> ago</div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Right Column: Modules + Actions -->
        <div class="sp-main-right">
            
            <!-- Security Modules Card -->
            <div class="sp-card sp-modules-card">
                <div class="sp-card-head">
                    <h3>Sicherheitsmodule</h3>
                    <a href="<?php echo admin_url('admin.php?page=safetypress-settings'); ?>" class="sp-card-action">Einstellungen →</a>
                </div>
                <div class="sp-modules-list">
                    <!-- Firewall -->
                    <div class="sp-module-row">
                        <div class="sp-module-icon orange">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M12.22 2H11.78C11.3 2 10.88 2.29 10.74 2.71L10.32 4H13.68L13.26 2.71C13.12 2.29 12.7 2 12.22 2ZM17 4L15 4H9L7 4L4 12L6 14V18C6 18.55 6.45 19 7 19H17C17.55 19 18 18.55 18 18V14L20 12L17 4ZM12 17C10.9 17 10 16.1 10 15C10 13.9 10.9 13 12 13C13.1 13 14 13.9 14 15C14 16.1 13.1 17 12 17Z"/></svg>
                        </div>
                        <div class="sp-module-info">
                            <h4>Web Application Firewall</h4>
                            <p>SQL-Injection & XSS Schutz</p>
                        </div>
                        <span class="sp-module-status <?php echo get_option('safetypress_enable_firewall', 1) ? 'active' : 'inactive'; ?>">
                            <?php echo get_option('safetypress_enable_firewall', 1) ? 'Aktiv' : 'Aus'; ?>
                        </span>
                    </div>
                    <!-- Login Protection -->
                    <div class="sp-module-row">
                        <div class="sp-module-icon blue">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"/></svg>
                        </div>
                        <div class="sp-module-info">
                            <h4>Login-Schutz</h4>
                            <p>Brute-Force Prevention</p>
                        </div>
                        <span class="sp-module-status <?php echo get_option('safetypress_enable_login_protection', 1) ? 'active' : 'inactive'; ?>">
                            <?php echo get_option('safetypress_enable_login_protection', 1) ? 'Aktiv' : 'Aus'; ?>
                        </span>
                    </div>
                    <!-- Hardening -->
                    <div class="sp-module-row">
                        <div class="sp-module-icon purple">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"/></svg>
                        </div>
                        <div class="sp-module-info">
                            <h4>WordPress Hardening</h4>
                            <p>Security Headers & mehr</p>
                        </div>
                        <span class="sp-module-status <?php echo get_option('safetypress_enable_hardening', 1) ? 'active' : 'inactive'; ?>">
                            <?php echo get_option('safetypress_enable_hardening', 1) ? 'Aktiv' : 'Aus'; ?>
                        </span>
                    </div>
                    <!-- Malware Scanner -->
                    <div class="sp-module-row">
                        <div class="sp-module-icon red">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5z"/></svg>
                        </div>
                        <div class="sp-module-info">
                            <h4>Malware Scanner</h4>
                            <p>Deep Scan & Integritätsprüfung</p>
                        </div>
                        <?php if (!$is_pro): ?>
                            <span class="sp-module-status pro">Pro</span>
                        <?php else: ?>
                            <span class="sp-module-status active">Aktiv</span>
                        <?php endif; ?>
                    </div>
                    <!-- 2FA -->
                    <div class="sp-module-row">
                        <div class="sp-module-icon cyan">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M17 1.01L7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z"/></svg>
                        </div>
                        <div class="sp-module-info">
                            <h4>Zwei-Faktor-Auth</h4>
                            <p>TOTP Authenticator</p>
                        </div>
                        <?php if (!$is_pro): ?>
                            <span class="sp-module-status pro">Pro</span>
                        <?php else: ?>
                            <span class="sp-module-status <?php echo get_option('safetypress_enable_2fa', 0) ? 'active' : 'inactive'; ?>">
                                <?php echo get_option('safetypress_enable_2fa', 0) ? 'Aktiv' : 'Aus'; ?>
                            </span>
                        <?php endif; ?>
                    </div>
                    <!-- SSL -->
                    <div class="sp-module-row">
                        <div class="sp-module-icon green">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6h2c0-1.66 1.34-3 3-3s3 1.34 3 3v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm0 12H6V10h12v10zm-6-3c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2z"/></svg>
                        </div>
                        <div class="sp-module-info">
                            <h4>SSL/HTTPS</h4>
                            <p>Verschlüsselte Verbindung</p>
                        </div>
                        <span class="sp-module-status <?php echo is_ssl() ? 'active' : 'inactive'; ?>">
                            <?php echo is_ssl() ? 'Aktiv' : 'Aus'; ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions + License in one row -->
            <div class="sp-bottom-row">
                <!-- Quick Actions -->
                <div class="sp-card sp-actions-card">
                    <div class="sp-card-head">
                        <h3>Schnellaktionen</h3>
                    </div>
                    <div class="sp-quick-actions">
                        <a href="<?php echo admin_url('admin.php?page=safetypress-scanner'); ?>" class="sp-quick-btn primary">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor"><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5z"/></svg>
                            Scan starten
                        </a>
                        <a href="<?php echo admin_url('admin.php?page=safetypress-firewall'); ?>" class="sp-quick-btn">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z"/></svg>
                            IPs verwalten
                        </a>
                        <a href="<?php echo admin_url('admin.php?page=safetypress-hardening'); ?>" class="sp-quick-btn">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z"/></svg>
                            Hardening
                        </a>
                        <a href="<?php echo admin_url('admin.php?page=safetypress-settings'); ?>" class="sp-quick-btn">
                            <svg width="18" height="18" viewBox="0 0 24 24" fill="currentColor"><path d="M19.14 12.94c.04-.31.06-.63.06-.94 0-.31-.02-.63-.06-.94l2.03-1.58c.18-.14.23-.41.12-.61l-1.92-3.32c-.12-.22-.37-.29-.59-.22l-2.39.96c-.5-.38-1.03-.7-1.62-.94l-.36-2.54c-.04-.24-.24-.41-.48-.41h-3.84c-.24 0-.43.17-.47.41l-.36 2.54c-.59.24-1.13.57-1.62.94l-2.39-.96c-.22-.08-.47 0-.59.22L2.74 8.87c-.12.21-.08.47.12.61l2.03 1.58c-.04.31-.06.63-.06.94s.02.63.06.94l-2.03 1.58c-.18.14-.23.41-.12.61l1.92 3.32c.12.22.37.29.59.22l2.39-.96c.5.38 1.03.7 1.62.94l.36 2.54c.05.24.24.41.48.41h3.84c.24 0 .44-.17.47-.41l.36-2.54c.59-.24 1.13-.56 1.62-.94l2.39.96c.22.08.47 0 .59-.22l1.92-3.32c.12-.22.07-.47-.12-.61l-2.01-1.58zM12 15.6c-1.98 0-3.6-1.62-3.6-3.6s1.62-3.6 3.6-3.6 3.6 1.62 3.6 3.6-1.62 3.6-3.6 3.6z"/></svg>
                            Einstellungen
                        </a>
                    </div>
                </div>

                <!-- License Status -->
                <div class="sp-card sp-license-card">
                    <div class="sp-card-head">
                        <h3>Lizenz</h3>
                    </div>
                    <?php if ($is_pro && $license_info): ?>
                        <div class="sp-license-active">
                            <div class="sp-license-check">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                            </div>
                            <div class="sp-license-text">
                                <strong>Pro Lizenz aktiv</strong>
                                <span>Alle Features freigeschaltet</span>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="sp-license-upgrade">
                            <p>Pro-Features freischalten:</p>
                            <ul>
                                <li>✓ Malware Deep-Scan</li>
                                <li>✓ Zwei-Faktor-Auth</li>
                                <li>✓ WooCommerce Schutz</li>
                            </ul>
                            <a href="<?php echo admin_url('admin.php?page=safetypress-license'); ?>" class="sp-license-btn">
                                Jetzt upgraden
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
